﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using EffectMaker.Foundation.Primitives;

namespace EffectMaker.Foundation.Editting
{
    /// <summary>
    /// 色編集対象
    /// </summary>
    public enum ColorTargetType
    {
        /// <summary>
        /// 色０
        /// </summary>
        Color0,

        /// <summary>
        /// 色１
        /// </summary>
        Color1,

        /// <summary>
        /// アルファ０
        /// </summary>
        Alpha0,

        /// <summary>
        /// アルファ１
        /// </summary>
        Alpha1,

        /// <summary>
        /// 色０
        /// </summary>
        GlobalColor0,

        /// <summary>
        /// 色１
        /// </summary>
        GlobalColor1,

        /// <summary>
        /// アルファ０
        /// </summary>
        GlobalAlpha0,

        /// <summary>
        /// アルファ１
        /// </summary>
        GlobalAlpha1,
    }

    /// <summary>
    /// 色編集情報
    /// </summary>
    public class EditingColorInfo
    {
        /// <summary>
        /// 色
        /// </summary>
        private ColorRgba color = new ColorRgba(1.0f, 1.0f, 1.0f, 1.0f);

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EditingColorInfo()
        {
        }

        /// <summary>
        /// コピーコンストラクタ
        /// </summary>
        /// <param name="src">コピー元オブジェクト</param>
        public EditingColorInfo(EditingColorInfo src)
        {
            this.Control = src.Control;
            this.Color = src.Color;
            this.Time = src.Time;
            this.RgbEditEnabled = src.RgbEditEnabled;
            this.AlphaEditEnabled = src.AlphaEditEnabled;
            this.TimeEditEnabled = src.TimeEditEnabled;
            this.IsEditing = src.IsEditing;
            this.RefreshTargetName = src.RefreshTargetName;
            this.RefreshColorPickerRequest = src.RefreshColorPickerRequest;
            this.LockingTabOrder = src.LockingTabOrder;
        }

        /// <summary>
        /// 編集コントロール
        /// </summary>
        public object Control { get; set; }

        /// <summary>
        /// 色
        /// </summary>
        public ColorRgba Color
        {
            get { return this.color.Clone() as ColorRgba; }
            set { this.color.Set(value); }
        }

        /// <summary>
        /// タブオーダーをカラーピッカーに固定する
        /// </summary>
        public bool LockingTabOrder { get; set; }

        /// <summary>
        /// 時間
        /// </summary>
        public int Time { get; set; }

        /// <summary>
        /// RGBの編集を有効にするか
        /// </summary>
        public bool RgbEditEnabled { get; set; }

        /// <summary>
        /// アルファの編集を有効にするか
        /// </summary>
        public bool AlphaEditEnabled { get; set; }

        /// <summary>
        /// 時間の編集を有効にするか
        /// </summary>
        public bool TimeEditEnabled { get; set; }

        /// <summary>
        /// 編集中か？
        /// true時は値の変更は行わずビューの更新のみ行う。
        /// </summary>
        public bool IsEditing { get; set; }

        /// <summary>
        /// リフレッシュ要求
        /// </summary>
        public bool RefreshRequest
        {
            get { return string.IsNullOrEmpty(this.RefreshTargetName) == false; }
        }

        /// <summary>
        /// リフレッシュ対象名
        /// </summary>
        public string RefreshTargetName { get; set; }

        /// <summary>
        /// カラーピッカーリフレッシュ要求
        /// </summary>
        public bool RefreshColorPickerRequest { get; set; }
    }
}
