﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.Foundation.Dynamic
{
    /// <summary>
    /// An empty implementation of the abstract SetMemberBinder class.
    /// </summary>
    public class EffectMakerSetMemberBinder : SetMemberBinder
    {
        /// <summary>The original value.</summary>
        private object originalValue = null;

        /// <summary>Flag indicates if the original value is explicitly set.</summary>
        private bool isOriginalValueSet = false;

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="name">The name of the related setter member.</param>
        /// <param name="shouldSetNonDynamicMember">
        /// Flag indicating whether should get non-dynamic member or not.
        /// </param>
        /// <param name="shouldIssueCommand">
        /// Flag indicating whether should issue command or not.
        /// </param>
        public EffectMakerSetMemberBinder(
            string name,
            bool shouldSetNonDynamicMember = false,
            bool shouldIssueCommand = false)
            : base(name, false)
        {
            this.ShouldSetNonDynamicMember = shouldSetNonDynamicMember;
            this.ShouldIssueCommand = shouldIssueCommand;
        }

        /// <summary>
        /// Get or set the flag indicating whether should set non-dynamic member or not.
        /// </summary>
        public bool ShouldSetNonDynamicMember { get; set; }

        /// <summary>
        /// Get or set the flag indicating whether should issue command or not.
        /// </summary>
        public bool ShouldIssueCommand { get; set; }

        /// <summary>
        /// Set or get the original value.
        /// </summary>
        public object OriginalValue
        {
            get
            {
                return this.originalValue;
            }

            set
            {
                this.originalValue = value;
                this.isOriginalValueSet = true;
            }
        }

        /// <summary>
        /// Get the flag indicating whether the original value is explicitly set.
        /// </summary>
        public bool IsOriginalValueSet
        {
            get { return this.isOriginalValueSet; }
        }

        /// <summary>
        /// Provides a fallback setter as dynamic object.
        /// (Not implemented)
        /// </summary>
        /// <param name="target">The target dynamic object.</param>
        /// <param name="value">The provided value.</param>
        /// <param name="errorSuggestion">An errorSuggestion dynamic object.</param>
        /// <returns>Returns nothing, throws a NotImplementedException.</returns>
        public override DynamicMetaObject FallbackSetMember(
            DynamicMetaObject target,
            DynamicMetaObject value,
            DynamicMetaObject errorSuggestion)
        {
            throw new NotImplementedException();
        }
    }
}
