﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.Foundation.Debugging.Profiling
{
    /// <summary>
    /// Class to store an instrumentation step information.
    /// </summary>
    [Serializable]
    public class InstrumentationStepInfo : IInstrumentationStepInfo
    {
        /// <summary>
        /// Initializes the StepInfo instance.
        /// </summary>
        /// <param name="description">Description of the step.</param>
        /// <param name="ticks">Ticks elapsed for the step.</param>
        public InstrumentationStepInfo(string description, long ticks)
        {
            if (string.IsNullOrWhiteSpace(description))
            {
                throw new ArgumentException("description");
            }

            this.Description = description;
            this.Ticks = ticks;
            this.CallCount = 1;
        }

        /// <summary>
        /// Gets the step description.
        /// </summary>
        public string Description { get; private set; }

        /// <summary>
        /// Gets or sets the instrumentation ticks.
        /// </summary>
        public long Ticks { get; set; }

        /// <summary>
        /// Gets or sets the call count.
        /// </summary>
        public uint CallCount { get; set; }
    }
}
