﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EffectMaker.Foundation.Collections
{
    /// <summary>
    /// ファイルコピーの入力パスと出力パスを保持するクラス
    /// </summary>
    public class FileCopyInfo
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="srcPath">入力パス</param>
        /// <param name="dstPath">出力パス</param>
        public FileCopyInfo(string srcPath, string dstPath)
        {
            this.SrcPath = srcPath;
            this.DstPath = dstPath;
        }

        /// <summary>
        /// 入力パス
        /// </summary>
        public string SrcPath { get; set; }

        /// <summary>
        /// 出力パス
        /// </summary>
        public string DstPath { get; set; }

        /// <summary>
        /// コピーの実行
        /// </summary>
        public void DoCopy()
        {
            if (string.IsNullOrEmpty(this.SrcPath) || string.IsNullOrEmpty(this.DstPath))
            {
                return;
            }

            if (string.Equals(this.SrcPath, this.DstPath, StringComparison.OrdinalIgnoreCase))
            {
                return;
            }

            File.Copy(this.SrcPath, this.DstPath, true);

            // 読み取り専用ファイルをコピーしてそのままにした場合、次回の上書き時にEffectMaker内で例外が発生してしまう。
            // (例えば、同一の読み取り専用テクスチャを参照している複数エミッタをエクスポートするとき)
            // これを防ぐために、上書きを許可する設定にしておく。
            FileInfo dstFileInfo = new FileInfo(this.DstPath);
            dstFileInfo.IsReadOnly = false;
        }
    }
}
