﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.Foundation.Coercers
{
    /// <summary>
    /// A base coercer abstract class.
    /// </summary>
    /// <typeparam name="T">The specific type of values to coerce.</typeparam>
    public abstract class CoercerBase<T> : ICoercer<T>
    {
        /// <summary>
        /// When implemented, coerces the input value.
        /// </summary>
        /// <param name="input">Input value to coerce.</param>
        /// <returns>Returns the coerced input value.</returns>
        public abstract T Coerce(T input);

        /// <summary>
        /// Coerces the input value.
        /// This method calls the generic Coerce method.
        /// </summary>
        /// <param name="input">Input value to coerce.</param>
        /// <returns>Returns the coerced input value.</returns>
        object ICoercer.Coerce(object input)
        {
            return this.Coerce((T)input);
        }
    }
}
