﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.Foundation.Coercers
{
    /// <summary>
    /// A coercer that aggregate several coercer to run them in chain.
    /// </summary>
    /// <typeparam name="T">The type of value to coerce.</typeparam>
    public class AggregateCoercer<T> : CoercerBase<T>
    {
        /// <summary>
        /// Stores the coercers to chain.
        /// </summary>
        private IEnumerable<ICoercer<T>> coercers;

        /// <summary>
        /// Initializes the AggregateCoercer instance.
        /// </summary>
        /// <param name="coercers">Coercers to chain.</param>
        public AggregateCoercer(IEnumerable<ICoercer<T>> coercers)
        {
            this.coercers = coercers;
        }

        /// <summary>
        /// Initializes the AggregateCoercer instance.
        /// </summary>
        /// <param name="coercers">Coercers to chain.</param>
        public AggregateCoercer(params ICoercer<T>[] coercers)
            : this((IEnumerable<ICoercer<T>>)coercers)
        {
        }

        /// <summary>
        /// Coerce the input value by running all the coercers in chain.
        /// The output of a coercer becomes the input of the next one, and so on.
        /// </summary>
        /// <param name="input">Input value to coerce.</param>
        /// <returns>Returns the input value after passing through to all coercers.</returns>
        public override T Coerce(T input)
        {
            foreach (ICoercer<T> coercer in this.coercers)
            {
                input = coercer.Coerce(input);
            }

            return input;
        }
    }
}
