﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.Foundation.Attributes
{
    /// <summary>
    /// Custom attribute for setting alias name.
    /// </summary>
    [AttributeUsage(AttributeTargets.All, AllowMultiple = false, Inherited = false)]
    public class AliasAttribute : System.Attribute
    {
        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="alias">command name.</param>
        public AliasAttribute(string alias)
        {
            this.Alias = alias;
        }

        /// <summary>
        /// Get the command name.
        /// </summary>
        public string Alias { get; private set; }
    }
}
