﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// コピー元ソースコード:
// Programs\Iris\Sources\Tools\Graphics\GraphicsTools\ShaderConverter\Include\gfxTool_ReadFile.h

#pragma once

#include <vector>
#include <functional>

#include <nn/gfxTool/gfxTool_Custom.h>

using namespace System::Threading;

namespace nn {
namespace gfxTool {

class ReadFile
{
public:
    static std::function< bool ( void**, size_t*, const char*, void* ) > GetCallback()
    {
        return []( void** ppOutFileData, size_t* pOutFileDataSize, const char* pFileName, void* pParam ) {
            return Callback( ppOutFileData, pOutFileDataSize, pFileName, pParam ); };
    }

    static bool Callback( void** ppOutFileData,
        size_t* pOutSize, const char* pFileName, void* pParam );

private:
    typedef std::pair< nn::gfxTool::Custom< std::string >::Type, nn::gfxTool::Custom< std::vector< char > >::Type > FileType;

    nn::gfxTool::Custom< std::vector< FileType > >::Type m_Files;
};

}
}
