﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include "gfxTool_ShaderConverterDll.h"

using namespace System;
using namespace System::Runtime::InteropServices;

namespace EffectMaker {
namespace SpecGeneric {
namespace Shader {

//---------------------------------------------------------------------------
//! @brief  シェーダコンバータのラッパークラスです。
//---------------------------------------------------------------------------
public ref class ShaderConverterWrapper
{
public:
    //---------------------------------------------------------------------------
    //! @brief  コンバート結果です。
    //---------------------------------------------------------------------------
    ref class ConvertResult
    {
    public:
        property int             ResultCode;  //!< リザルトコード
        property System::String^ DefaultLog;  //!< 標準ログの内容
        property System::String^ WarningLog;  //!< 警告ログの内容
        property System::String^ ErrorLog;    //!< エラーログの内容
    };

    //---------------------------------------------------------------------------
    //! @brief  コンストラクタです。
    //---------------------------------------------------------------------------
    ShaderConverterWrapper();

    //---------------------------------------------------------------------------
    //! @brief  デストラクタです。
    //---------------------------------------------------------------------------
    ~ShaderConverterWrapper();

    //---------------------------------------------------------------------------
    //! @brief  ファイナライザです。
    //---------------------------------------------------------------------------
    !ShaderConverterWrapper();

    //---------------------------------------------------------------------------
    //! @brief     DLLを初期化します。
    //! @param[in] dllPath  DLLのパス
    //---------------------------------------------------------------------------
    void Initialize(System::String^ dllPath);

    //---------------------------------------------------------------------------
    //! @brief  DLLを破棄します。
    //---------------------------------------------------------------------------
    void Release();

    //---------------------------------------------------------------------------
    //! @brief     コンバート処理を実行します。
    //! @param[in] args  コンバート引数
    //! @return    コンバート結果を返します。
    //---------------------------------------------------------------------------
    ConvertResult^ Execute(System::String^ args);

private:
    nn::gfxTool::ShaderConverterDll* m_pShaderConverterDll;  //!< ShaderConverterのDLLアセンブリ
};

}
}
}
