﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShaderConverterWrapper_PCH.h"
#include "DotNetMessage.h"

#using <system.dll>


namespace EffectMaker {
namespace ShaderConverterWrapper {

    /// <summary>
    /// Constructor.
    /// </summary>
    /// <param name="pMessage">The native message data from the shader converter.</param>
    DotNetMessage::DotNetMessage(const MessageBase *pMessage)
    {
        int argCount = pMessage->GetArgumentCount();

        this->m_name = gcnew String(pMessage->GetMessageName());
        this->m_pArguments = gcnew array<String^>(argCount);
        this->m_pArgNameMap = gcnew Dictionary<String^, int>();

        if (argCount > 0)
        {
            String ^argNamesStr = gcnew String(pMessage->GetArgumentNames());
            array<String^> ^tokens =
                argNamesStr->Split(s_delimiters, System::StringSplitOptions::RemoveEmptyEntries);

            for (int i = 0; i < argCount; ++i)
            {
                const char *szArgument = pMessage->GetArgument(i);

                this->m_pArguments[i] =
                    szArgument == NULL ? String::Empty : gcnew String(szArgument);

                this->m_pArgNameMap->Add(tokens[i], i);
            }
        }
    }

    /// <summary>
    /// Get argument value of the message.
    /// </summary>
    /// <param name="argName">The name of the argument.</param>
    String^ DotNetMessage::GetArg(String ^argName)
    {
        int index;
        if (this->m_pArgNameMap->TryGetValue(argName, index) == false)
        {
            return nullptr;
        }

        return this->m_pArguments[index];
    }

} // namespace ShaderConverterWrapper
} // namespace EffectMaker
