﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShaderConverterLib_Debug_H__
#define __ShaderConverterLib_Debug_H__


namespace EffectMaker {
namespace ShaderConverterLib {

    /// <summary>
    /// Set message forwarder.
    /// </summary>
    /// <param name="pMsgForwarder">The message forwarder.</param>
    void LIB_API SetMessageForwarder(IMessageForwarder *pMsgForwarder);

    /// <summary>
    /// Forward a message to the application for processing or displaying.
    /// </summary>
    /// <param name="pMessage">The message to send.</param>
    void ForwardMessage(MessageBase *pMessage);

    /// <summary>
    /// Log message.
    /// (the Unicode version)
    /// </summary>
    /// <param name="szFormat">The format string.</param>
    void LogMessage(const wchar_t *szFormat, ...);

    /// <summary>
    /// Log message.
    /// (the ASCII version)
    /// </summary>
    /// <param name="szFormat">The format string.</param>
    void LogMessage(const char *szFormat, ...);

} // namespace ShaderConverterLib
} // namespace EffectMaker

#endif // __ShaderConverterLib_Debug_H__
