﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//--------------------------------------------------------------------------------
//  EffectMakerからのランタイム利用
//--------------------------------------------------------------------------------
#define VFX_ENDIAN_LITTLE           1   // NOLINT(readability/define)
#define VFX_BI_ENDIAN               1   // NOLINT(readability/define)
#define VFX_USE_UNIFORM_BLOCK
#define VFX_USE_INSTANS_DRAW

#define NN_UNUSED(Variable) (void)(&Variable);
#define NN_NOEXCEPT
#define NN_DISALLOW_COPY(x)
#define NN_SDK_ASSERT(x)

//--------------------------------------------------------------------------------
//! @brief  エンディアン指定
//--------------------------------------------------------------------------------
enum EndianMode
{
    EndianMode_Little = 0,  //!< リトルエンディアン
    EndianMode_Big = 1,     //!< ビッグエンディアン
};
static const EndianMode SystemEndianType = EndianMode_Little;   //!< エンディアン型

//--------------------------------------------------------------------------------
//  vfx_Data.h で使用する NintendoSDK インターフェース 型の定義をここに暫定配置しておきます。
//  ShaderCodeGeneratorGeneric 側から、nn/util/util_MathTypes.h などを直接 include できないためです。
//  TODO: このプロジェクトからきちんと NintendoSDK のヘッダを引けるように調整。
//--------------------------------------------------------------------------------
namespace nn { namespace util {
/**
* @brief    単精度浮動小数点型の配列によって 2 次元ベクトルを表現します。
*/
struct Float2
{
    float v[2];     //!< 要素配列
};

/**
* @brief    単精度浮動小数点型の配列によって 3 次元ベクトルを表現します。
*/
struct Float3
{
    float v[3];     //!< 要素配列
};

/**
* @brief    単精度浮動小数点型の配列によって 4 次元ベクトルを表現します。
*/
struct Float4
{
    float v[4];     //!< 要素配列
};
}
}
