﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef __ShaderCodeGeneratorGeneric_PCH_H__
#define __ShaderCodeGeneratorGeneric_PCH_H__

//=========================================================================
//
// Constants
//
//=========================================================================
#define SHADER_BINARY_BUFFER_SIZE 125829120 ///< 120 MB for shader binary output.

//=========================================================================
//
// Include files
//
//=========================================================================
#include "vfx_RuntimeDefinitions.h"

#include <vcclr.h>

#include <GL/glew.h>
#include <Windows.h>

#include <nw/eft/typeDef2.h>
#include <nw/eft/eft2_EndianUtil.h>
#include <nw/eft/eft2_ShaderKey.h>
#include "vfx_ShaderKey.h"

#include "Types.h"
#include "ShaderCompileErrorInfo.h"
#include "ShaderCompileErrorList.h"
#include "ShaderConverterEmitterData.h"
#include "ShaderConversionInputData.h"
#include "ShaderConverter.h"
#include "ShaderCodeGeneratorGenericUtility.h"

#endif // __ShaderCodeGeneratorGeneric_PCH_H__
