﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Windows.Forms;
using EffectMaker.Foundation.Primitives;
using EffectMaker.UIControls.Specifics.TableEditor;

namespace EffectMaker.Application.TestDialog
{
    /// <summary>
    /// The table editor data grid test.
    /// </summary>
    public partial class TableEditorDataGridTest : Form
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="TableEditorDataGridTest"/> class.
        /// </summary>
        public TableEditorDataGridTest()
        {
            this.InitializeComponent();

            //// テスト用初期値設定コード

            // 本来はXAMLで指定する
            this.dataGridView1.Columns.AddRange(new DataGridViewColumn[]
            {
                new TableEditorColumn()
                {
                    Name = "Key Frame"
                },
                new TableEditorColumn()
                {
                    Name = "X", MaxCellValue = 1.0f, MinCellValue = 0.0f, DefaultCellValue = 0.0f
                },
                new TableEditorColumn()
                {
                    Name = "Y", MaxCellValue = 1.0f, MinCellValue = 0.0f, DefaultCellValue = 0.0f
                },
                new TableEditorColumn()
                {
                    Name = "Z", MaxCellValue = 1.0f, MinCellValue = 0.0f, DefaultCellValue = 0.0f
                }
            });

            var pairs = new List<KeyValuePair<int, EffectMaker.Foundation.Primitives.Primitivef>>();

            for (int i = 0; i < 8; ++i)
            {
                EffectMaker.Foundation.Primitives.Primitivef primitive = new Vector3f(1.0f, 2.0f, 3.0f);
                var elem = new KeyValuePair<int, EffectMaker.Foundation.Primitives.Primitivef>(i, primitive);

                pairs.Add(elem);
            }

            this.dataGridView1.Values = pairs;
        }

        /// <summary>
        /// The proc add.
        /// </summary>
        /// <param name="sender">
        /// The sender.
        /// </param>
        /// <param name="e">
        /// The e.
        /// </param>
        private void ProcAdd(object sender, EventArgs e)
        {
            this.dataGridView1.AddRow(false);
        }

        /// <summary>
        /// The proc delete.
        /// </summary>
        /// <param name="sender">
        /// The sender.
        /// </param>
        /// <param name="e">
        /// The e.
        /// </param>
        private void ProcDelete(object sender, EventArgs e)
        {
            this.dataGridView1.DeleteRow();
        }

        /// <summary>
        /// The proc reset.
        /// </summary>
        /// <param name="sender">
        /// The sender.
        /// </param>
        /// <param name="e">
        /// The e.
        /// </param>
        private void ProcReset(object sender, EventArgs e)
        {
            this.dataGridView1.Values = new List<KeyValuePair<int, Primitivef>>();
        }

        /// <summary>
        /// The proc debug.
        /// </summary>
        /// <param name="sender">
        /// The sender.
        /// </param>
        /// <param name="e">
        /// The e.
        /// </param>
        private void ProcDebug(object sender, EventArgs e)
        {
            var gotData = this.dataGridView1.Values;
            string output = string.Empty;
            foreach (var value in gotData)
            {
                output += value + "\r\n";
            }

            MessageBox.Show(output);
        }
    }
}
