﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace EffectMaker.Application.OptionPanes
{
    /// <summary>
    /// オプションウィンドウで、スペックを選択するためのComboBox
    /// </summary>
    public class SpecComboBox : ComboBox
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SpecComboBox() : base()
        {
            this.DrawMode = DrawMode.OwnerDrawFixed;
        }

        /// <summary>
        /// ユーザがEffectMaker上で使用しているスペックのindex
        /// </summary>
        public int CurrentSpecIndex
        {
            get;
            set;
        }

        /// <summary>
        /// 現在使用しているスペックだけ、太字で表示する
        /// </summary>
        /// <param name="e">イベント データを格納している。</param>
        protected override void OnDrawItem(DrawItemEventArgs e)
        {
            base.OnDrawItem(e);

            // デザイナで表示するときにe.Indexが-1になる
            if (e.Index < 0 || e.Index >= Items.Count)
            {
                return;
            }

            e.DrawBackground();
            e.DrawFocusRectangle();

            // スペック名の描画を行う
            var rect = new Rectangle(e.Bounds.X, e.Bounds.Y, e.Bounds.Width, e.Bounds.Height);
            Font font = this.Font;

            // 現在選択されているスペックだったら太字で描画する
            if (e.Index == this.CurrentSpecIndex)
            {
                font = new Font(this.Font, FontStyle.Bold);
            }

            TextRenderer.DrawText(e.Graphics, this.Items[e.Index].ToString(), font, rect, e.ForeColor,
                                    TextFormatFlags.Left | TextFormatFlags.VerticalCenter);

        }
    }
}
