﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using EffectMaker.BusinessLogic.Options;
using EffectMaker.Foundation.Attributes;

namespace EffectMaker.Application.OptionPanes
{
    /// <summary>
    /// Effect Browser options.
    /// </summary>
    [DisplayOrder(6)]
    public partial class EffectBrowserOptionPane : UserControl, IOptionPane
    {
        /// <summary>
        /// Initializes the EffectBrowserOptionPane instance.
        /// </summary>
        public EffectBrowserOptionPane()
        {
            this.InitializeComponent();

            this.btnDeleteCache.Click += this.OnDeleteCacheButtonClick;
        }

        /// <summary>
        /// Gets the identifier.
        /// </summary>
        public string Identifier
        {
            get { return "EffectBrowserOptionPane"; }
        }

        /// <summary>
        /// Gets the parent identifier.
        /// </summary>
        public string ChildOf
        {
            get { return null; }
        }

        /// <summary>
        /// Gets the display name.
        /// </summary>
        public string DisplayName
        {
            get { return Properties.Resources.OptionPaneEffectBrowser; }
        }

        /// <summary>
        /// Called when initialized.
        /// </summary>
        public void OnInitialize()
        {
            EffectBrowserOptions options = OptionStore.RootOptions.EffectBrowser;

            this.chkShowHiddenFilesFolders.Checked = options.ShowHiddenEntries;

            // オプショングループラベル設定
            this.grpOptions.Text = Properties.Resources.OptionEffectBrowserOption;
            this.chkShowHiddenFilesFolders.Text = Properties.Resources.OptionEffectBrowserShowHiddenFolders;
            this.lblDeleteCacheInfo.Text = Properties.Resources.OptionEffectBrowserClearCache;
            this.btnDeleteCache.Text = Properties.Resources.OptionButtonDelete;
        }

        /// <summary>
        /// Called when terminated.
        /// </summary>
        public void OnTerminate()
        {
        }

        /// <summary>
        /// Called when the Accept button is clicked.
        /// </summary>
        public void OnAccept()
        {
            EffectBrowserOptions options = OptionStore.RootOptions.EffectBrowser;

            options.ShowHiddenEntries = this.chkShowHiddenFilesFolders.Checked;
        }

        /// <summary>
        /// Called when the Cancel button is clicked.
        /// </summary>
        public void OnCancel()
        {
        }

        /// <summary>
        /// Called when the DeleteCache Button is clicked.
        /// </summary>
        /// <param name="sender">The DeleteCache Button.</param>
        /// <param name="e">Event argument.</param>
        private void OnDeleteCacheButtonClick(object sender, EventArgs e)
        {
        }
    }
}
