﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.Application
{
    /// <summary>
    /// Represent the required elements to make an option pane.
    /// </summary>
    public interface IOptionPane
    {
        /// <summary>
        /// Unique identifier of the option pane
        /// </summary>
        string Identifier { get; }

        /// <summary>
        /// Set the identifier of the parent if the pane becomes a child pane.
        /// Set to null if the pane is a root pane.
        /// </summary>
        string ChildOf { get; }

        /// <summary>
        /// NameWithExpander to be displayed in the user interface.
        /// </summary>
        string DisplayName { get; }

        /// <summary>
        /// オプションウィンドウのTreeViewを再描画するdelegate
        /// </summary>
        Action DrawTreeView { get; set; }

        /// <summary>
        /// Method called just after the option pane has been instanced.
        /// </summary>
        void OnInitialize();

        /// <summary>
        /// Method called when option window is closed.
        /// </summary>
        void OnTerminate();

        /// <summary>
        /// Method called when the user click the Accept button of the options dialog.
        /// </summary>
        /// <returns>入力に不正がなければtrue,入力が不正であればfalse.</returns>
        bool OnAccept();

        /// <summary>
        /// Method called when the user click the Cancel button of the options dialog.
        /// </summary>
        void OnCancel();

        /// <summary>
        /// プロジェクトコンフィグが読み込まれた際に、その内容にUIを更新します。
        /// </summary>
        void OnProjectSettingChanged();

        /// <summary>
        /// プロジェクトコンフィグをファイル出力する際に各UIの内容を出力用インスタンスに収集します。
        /// </summary>
        void OnExportProjectSetting();

        /// <summary>
        /// 設定確定時に各ペインでパス設定項目をチェックし、不正な設定があったらfalseを返す関数を定義してください。
        /// </summary>
        /// <returns>不正な設定がなければtrue、不正な設定があればfalse.</returns>
        bool OnValidationCheck();
    }
}
