﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace EffectMaker.Application.CommandLine
{
    /// <summary>
    /// コンバートリストオプションを処理します。
    /// </summary>
    public class ConvertListProcessor : CommandLineProcessorBase
    {
        /// <summary>
        /// コンバートリストファイルです。
        /// </summary>
        private string convertListFile;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="workingData">作業データ</param>
        /// <param name="convertListFile">コンバートリストファイル</param>
        public ConvertListProcessor(CommandLineWorkingData workingData, string convertListFile)
            : base(workingData)
        {
            this.convertListFile = convertListFile;
        }

        /// <summary>
        /// エラーログを取得します。
        /// </summary>
        public override string ErrorReport { get { return string.Empty; } }

        /// <summary>
        /// 設定処理を行います。
        /// </summary>
        /// <returns>処理が正常に完了したときtrue, それ以外はfalseを返します。</returns>
        public override bool Setup()
        {
            // コンバートリストファイルをロード
            ConvertListFile convertListFile = new ConvertListFile();
            bool resLoad = convertListFile.Load(this.convertListFile);

            if (!resLoad)
            {
                return false;
            }

            this.WorkingData.ConvertListFilePath = convertListFile.AbsoluteFilePath;
            this.WorkingData.WorkingFolder = convertListFile.WorkingFolder;

            this.WorkingData.Converter.BinaryName = convertListFile.BinaryName;
            this.WorkingData.Converter.EsetPathList = convertListFile.EsetPathList;
            this.WorkingData.Converter.ProjectName = convertListFile.ProjectName;

            return true;
        }

        /// <summary>
        /// コマンドライン処理を行います。
        /// </summary>
        /// <returns>処理が正常に完了したときtrue, それ以外はfalseを返します。</returns>
        public override bool Process()
        {
            return true;
        }

        /// <summary>
        /// 書き換えた設定などを復元します。
        /// </summary>
        public override void Cleanup()
        {
        }
    }
}
