﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;

namespace EffectMaker.Application.CommandLine
{
    /// <summary>
    /// コマンドラインで使用する作業データです。
    /// </summary>
    public class CommandLineWorkingData
    {
        /// <summary>
        /// バイナリコンバータです。
        /// </summary>
        public readonly CommandLineBinaryConverter Converter = new CommandLineBinaryConverter();

        /// <summary>
        /// 静的解析のためのプロファイラです。
        /// </summary>
        public readonly StaticProfiler Profiler = new StaticProfiler();

        /// <summary>
        /// プロジェクト設定ファイルパスを取得または設定します。
        /// </summary>
        public string ProjectConfigFilePath { get; set; }

        /// <summary>
        /// コンバートリストのファイルパスを取得または設定します。
        /// </summary>
        public string ConvertListFilePath { get; set; }

        /// <summary>
        /// ワーキングフォルダを取得または設定します。
        /// </summary>
        public string WorkingFolder { get; set; }

        /// <summary>
        /// エミッタセットヘッダファイルパスを取得または設定します。
        /// </summary>
        public string EsetHeaderFilePath { get; set; }

        /// <summary>
        /// APIタイプ(プラットフォーム)オプションが指定されたか取得または設定します。
        /// </summary>
        public bool ApiTypeOptionEnabled { get; set; }
    }
}
