﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class StripeComplexBinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>A flag to prevent the static constructor being called more than once.</summary>
        private static bool isStaticConstructorCalled = false;

        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static StripeComplexBinaryConversionInfo()
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private StripeComplexBinaryConversionInfo(DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }
    }
}
