﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare
  File:     eft_Stripe.vsh

  Copyright (C)2011-2013 Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#define sysStripeRandom         sysEmitterPluginUniformBlockParam0
#define sysStripeHeadAlpha      sysEmitterPluginUniformBlockParam1.x
#define sysStripeTailAlpha      sysEmitterPluginUniformBlockParam1.y
#define sysStripeColor0         sysEmitterPluginUniformBlockParam2
#define sysStripeColor1         sysEmitterPluginUniformBlockParam3
#define sysStripeTime           sysEmitterPluginUniformBlockParam4.x
#define sysStripePointSum       sysEmitterPluginUniformBlockParam4.y
#define sysStripeCrossMode      sysEmitterPluginUniformBlockParam4.z
#define sysStripeLife           sysEmitterPluginUniformBlockParam4.w
#ifndef _VFX_NSDK01215_COMPATIBLE
#define sysStripeHeadPos        sysEmitterPluginUniformBlockParam5.xyz
#endif

#ifdef _USE_NN_VFX
#define sysStripePointID        ( sysEmitterPluginAttr2.w )
#define sysStripePointPos       ( sysEmitterPluginAttr0.xyz )
#define sysStripeWingLength     ( sysEmitterPluginAttr0.w )
#define sysStripePointDir       ( sysEmitterPluginAttr1.xyz )
#define sysStripePointEmat      ( sysEmitterPluginAttr2.xyz )
#define sysStripePointTexV      ( sysEmitterPluginAttr1.w )
#else
#define sysStripePointID        ( gl_VertexID / 2 )
#define sysStripePointPos       ( sysPosAttr.xyz )
#define sysStripeWingLength     ( sysPosAttr.w )
#define sysStripePointDir       ( sysEmitterPluginAttr0.xyz )
#define sysStripePointEmat      ( sysEmitterPluginAttr1.xyz )
#define sysStripePointTexV      ( sysEmitterPluginAttr0.w )
#endif

//---------------------------------------------------
// Zバッファの奥行きを取得して、指定のz値が隠れているならを、見えているなら1を返す
//---------------------------------------------------
#ifndef USE_USR_CHECK_DEPTH_BUFFER
float CheckDepthBuffer( vec2 ofs, vec4 outDepthTexCoordProj, float pz )
{
    float tz = GetDepthValueFromTexture( outDepthTexCoordProj + vec4( ofs, 0, 0 ) );
    float dis = tz - pz;
    return step( 0.0, dis );
}
#endif

//---------------------------------------------------
// 遮蔽チェック
//---------------------------------------------------
#ifndef USE_USR_VERTEX_MASKING_CHECK
float CalcMaskingCheck( vec4 ptclFragCoordCenter, float sysPtclCenterDepth )
{
    float alphaRate = 1.0;

    vec4 outDepthTexCoordProj = ptclFragCoordCenter;

    // ピクセルZを取得する
    float cpz = sysPtclCenterDepth;

    // 外側と内側のサンプリング点のデプスバッファとの前後関係を取得
    float r = alphaFunc0.y;
    float out_sum = 0.0;
    float in_sum = 0.0;

    // 外側の点
    out_sum += 2.0 * CheckDepthBuffer( vec2( -0.8, -0.7 )*1.0*r, outDepthTexCoordProj, cpz );
    out_sum += 1.0 * CheckDepthBuffer( vec2( -1, 0 )*1.0*r, outDepthTexCoordProj, cpz );
    out_sum += 2.0 * CheckDepthBuffer( vec2( 0.7, 0.8 )*1.0*r, outDepthTexCoordProj, cpz );
    out_sum += 1.0 * CheckDepthBuffer( vec2( 0, -1 )*1.0*r, outDepthTexCoordProj, cpz );

    out_sum += 1.0 * CheckDepthBuffer( vec2( 0, 1 )*1.0*r, outDepthTexCoordProj, cpz );
    out_sum += 2.0 * CheckDepthBuffer( vec2( 0.7, -0.8 )*1.0*r, outDepthTexCoordProj, cpz );
    out_sum += 1.0 * CheckDepthBuffer( vec2( 1, 0 )*1.0*r, outDepthTexCoordProj, cpz );
    out_sum += 2.0 * CheckDepthBuffer( vec2( 0.8, 0.7 )*1.0*r, outDepthTexCoordProj, cpz );

    out_sum += 2.0 * CheckDepthBuffer( vec2( -0.8, -0.7 )*0.7*r, outDepthTexCoordProj, cpz );
    out_sum += 1.0 * CheckDepthBuffer( vec2( -1, 0 )*0.7*r, outDepthTexCoordProj, cpz );
    out_sum += 2.0 * CheckDepthBuffer( vec2( 0.7, 0.8 )*0.7*r, outDepthTexCoordProj, cpz );
    out_sum += 1.0 * CheckDepthBuffer( vec2( 0, -1 )*0.7*r, outDepthTexCoordProj, cpz );

    out_sum += 1.0 * CheckDepthBuffer( vec2( 0, 1 )*0.7*r, outDepthTexCoordProj, cpz );
    out_sum += 2.0 * CheckDepthBuffer( vec2( 0.7, -0.8 )*0.7*r, outDepthTexCoordProj, cpz );
    out_sum += 1.0 * CheckDepthBuffer( vec2( 1, 0 )*0.7*r, outDepthTexCoordProj, cpz );
    out_sum += 2.0 * CheckDepthBuffer( vec2( 0.8, 0.7 )*0.7*r, outDepthTexCoordProj, cpz );

    out_sum += 2.0 * CheckDepthBuffer( vec2( -0.8, -0.7 )*0.4*r, outDepthTexCoordProj, cpz );
    out_sum += 1.0 * CheckDepthBuffer( vec2( -1, 0 )*0.4*r, outDepthTexCoordProj, cpz );
    out_sum += 2.0 * CheckDepthBuffer( vec2( 0.7, 0.8 )*0.4*r, outDepthTexCoordProj, cpz );
    out_sum += 1.0 * CheckDepthBuffer( vec2( 0, -1 )*0.4*r, outDepthTexCoordProj, cpz );

    out_sum += 1.0 * CheckDepthBuffer( vec2( 0, 1 )*0.4*r, outDepthTexCoordProj, cpz );
    out_sum += 2.0 * CheckDepthBuffer( vec2( 0.7, -0.8 )*0.4*r, outDepthTexCoordProj, cpz );
    out_sum += 1.0 * CheckDepthBuffer( vec2( 1, 0 )*0.4*r, outDepthTexCoordProj, cpz );
    out_sum += 2.0 * CheckDepthBuffer( vec2( 0.8, 0.7 )*0.4*r, outDepthTexCoordProj, cpz );

    // 内側の点
    in_sum += 3.0 * CheckDepthBuffer( vec2( -0.2, -0.4 )*1.2*r, outDepthTexCoordProj, cpz );
    in_sum += 3.0 * CheckDepthBuffer( vec2( 0.2, 0.4 )*1.2*r, outDepthTexCoordProj, cpz );
    in_sum += 3.0 * CheckDepthBuffer( vec2( 0.4, -0.2 )*1.2*r, outDepthTexCoordProj, cpz );
    in_sum += 3.0 * CheckDepthBuffer( vec2( -0.4, 0.2 )*1.2*r, outDepthTexCoordProj, cpz );

    in_sum += 3.0 * CheckDepthBuffer( vec2( -0.1, -0.2 )*1.0*r, outDepthTexCoordProj, cpz );
    in_sum += 3.0 * CheckDepthBuffer( vec2( 0.1, 0.2 )*1.0*r, outDepthTexCoordProj, cpz );
    in_sum += 3.0 * CheckDepthBuffer( vec2( 0.2, -0.1 )*1.0*r, outDepthTexCoordProj, cpz );
    in_sum += 3.0 * CheckDepthBuffer( vec2( -0.2, 0.1 )*1.0*r, outDepthTexCoordProj, cpz );

    in_sum += 5.0 * CheckDepthBuffer( vec2( 0, 0 )*r, outDepthTexCoordProj, cpz );

    // 外側の遮蔽率と、内側の遮蔽率を個別に乗算して減衰(内側が全点隠れたら消えるようにするため)
    alphaRate *= clamp( out_sum / 35.0, 0.0, 1.0 );
    alphaRate *= clamp( in_sum / 7.0, 0.0, 1.0 );

    return alphaRate;
}
#endif

//-------------------------------------------
//  ストライプのメイン関数
//-------------------------------------------
#define USE_USR_VERTEX_MAIN     // デフォルトのメイン関数を上書きします。
void main()
{
    // パーティクル時間
    sysPtclTime = sysStripeTime;

    // 履歴点をPtcl代表点として記録
    sysPtclWorldPos.xyz = sysStripePointPos;

    // デプス、カメラオフセット距離
    #define offsetParam ubCenter.z

    // カメラオフセット
    vec3 center;
    center.x = sysEmitterMatrix[0].w;
    center.y = sysEmitterMatrix[1].w;
    center.z = sysEmitterMatrix[2].w;
    vec3 camOffset = CalculateCameraOffset( center );

    // ビルボード
#ifdef _STRIPE_BILLBOARD
    vec3 dir = normalize( sysStripePointDir );
    vec3 wing = normalize( cross( eyeVec.xyz, dir ) );
    gl_Position.xyz = sysStripePointPos - wing * sysStripeWingLength * 0.5;
    gl_Position.w   = 1;
    sysWorldNormalVary = cross( dir, wing );    // 法線を設定
#endif

#if defined( _STRIPE_EMITTER_MATRIX ) || defined( _STRIPE_EMITTER_UPDOWN )
    vec3 matv = sysStripePointEmat;
#endif

    // エミッタマトリクス
#ifdef _STRIPE_EMITTER_MATRIX
    vec3 dir = normalize( sysStripePointDir );
    vec3 wing = normalize( cross( matv, dir ) );
    if( sysStripeCrossMode == 1 )
    {
        wing = normalize( cross( wing, dir ) );
    }
    gl_Position.xyz = sysStripePointPos - wing * sysStripeWingLength * 0.5;
    gl_Position.w   = 1;
    sysWorldNormalVary = cross( dir, wing );    // 法線を設定
#endif

    // エミッタ上下
#ifdef _STRIPE_EMITTER_UPDOWN
    vec3 dir = normalize( sysStripePointDir );
    vec3 wing = matv;
    if( sysStripeCrossMode == 1 )
    {
        wing = normalize( cross( wing, dir ) );
    }
    gl_Position.xyz = sysStripePointPos - wing * sysStripeWingLength * 0.5;
    gl_Position.w   = 1;
    sysWorldNormalVary = cross( dir, wing );    // 法線を設定
#endif

#ifdef _STRIPE_FOLLOW_EMITTER_MATRIX
    // エミッタに完全追従の場合、ローカル系からワールド系に変換
    gl_Position.xyz = ( vec4( gl_Position.xyz, 1 ) * sysEmitterMatrix ).xyz;
#ifdef _VFX_NSDK01215_COMPATIBLE
    sysWorldNormalVary.xyz = ( vec4( sysWorldNormalVary, 1 ) * sysEmitterMatrix ).xyz;
#else
    // MEMO: 法線なので、平行移動成分を加味しないように修正。
    sysWorldNormalVary.xyz = ( vec4( sysWorldNormalVary, 0 ) * sysEmitterMatrix ).xyz;
#endif
#endif

    // 接線・従法線の計算
    sysWorldTangentVary = normalize( wing );
    sysWorldBinormalVary = cross( sysWorldTangentVary, sysWorldNormalVary );

    // カメラオフセット
    gl_Position.xyz += camOffset;

    // ワールド座標調整
    AdjustmentWorldPosition();

    // ワールド座標
    sysWorldPositionVary = gl_Position.xyz;

    // スクリーン座標系へ変換
    gl_Position *= sysViewProjectionMatrix;

    // デプスオフセット
    if ( CHECK_BIT_FLAG( BIT_FLAG_OFFSET_TYPE_DEPTH ) )
    {
        gl_Position.z -= offsetParam * ( 1 - gl_Position.z / gl_Position.w );
    }

    // 視線ベクトル
    sysEyeVecVary.xyz = sysWorldPositionVary.xyz - eyePos.xyz;

    // カラー
    // ストライプColor x エミッタColor
    sysColor0Vary = sysStripeColor0 * sysEmitterColor0;
    sysColor1Vary = sysStripeColor1 * sysEmitterColor1;

    sysPrimitiveColorVary = vec4( 1 );
    //--------------------------------------------------------------
    // テクスチャ  パターン・座標アニメーション処理
    //--------------------------------------------------------------

    int ptclTexturePtn0;    // テクスチャパターン 0
    int ptclTexturePtn1;    // テクスチャパターン 1
    int ptclTexturePtn2;    // テクスチャパターン 2

    // テクスチャ座標
    float u = 1.0;
    if( sysStripeWingLength > 0.0 )
    {
        u = 0.0;
    }

    vec2 defuv = vec2( u, -sysStripePointTexV );

    vec2 inUv0   = defuv;
    vec2 inUv1   = defuv;
    vec2 inUv2   = defuv;
    vec4 outUv0  = vec4( 0 );
    vec4 outUv1  = vec4( 0 );
    vec4 outUv2  = vec4( 0 );

    // スフィアマップ テクスチャ座標を計算する
#if 0
    vec2 sphereMapTexCoord;
    vec3 viewPosition = normalize( ( vec4( sysWorldPositionVary, 1 ) * sysViewMatrix ).xyz );
    vec3 viewNormal   = normalize( ( vec4( sysWorldNormalVary,   0 ) * sysViewMatrix ).xyz );

    viewNormal.z = clamp( viewNormal.z, 0.2, 1.0 );     // 暫定処理（zの負数を回避）

    vec3 r = reflect( viewPosition, viewNormal );
    r.z = r.z + 1.0;
    float m = 2.0 * sqrt( dot(r, r) );
    sphereMapTexCoord.x =  (r.x / m) + 0.5;
    sphereMapTexCoord.y = -(r.y / m) + 0.5;

#ifdef _TEX_0_SPHERE_MAP
        inUv0.xy = sphereMapTexCoord;
#endif
#ifdef _TEX_1_SPHERE_MAP
        inUv1.xy = sphereMapTexCoord;
#endif
#ifdef _TEX_2_SPHERE_MAP
        inUv2.xy = sphereMapTexCoord;
#endif
#endif


    // 反転ランダムを処理
#ifdef _PARTICLE
    if ( CHECK_BIT_FLAG( BIT_FLAG_TEX0_INV_RANDOM_U ) ) { if ( sysStripeRandom.x > 0.5 ) inUv0.x = -inUv0.x; }
    if ( CHECK_BIT_FLAG( BIT_FLAG_TEX0_INV_RANDOM_V ) ) { if ( sysStripeRandom.y > 0.5 ) inUv0.y = -inUv0.y; }
    if ( CHECK_BIT_FLAG( BIT_FLAG_TEX1_INV_RANDOM_U ) ) { if ( sysStripeRandom.z > 0.5 ) inUv1.x = -inUv1.x; }
    if ( CHECK_BIT_FLAG( BIT_FLAG_TEX1_INV_RANDOM_V ) ) { if ( sysStripeRandom.w > 0.5 ) inUv1.y = -inUv1.y; }
    if ( CHECK_BIT_FLAG( BIT_FLAG_TEX2_INV_RANDOM_U ) ) { if ( sysStripeRandom.y > 0.5 ) inUv2.x = -inUv2.x; }
    if ( CHECK_BIT_FLAG( BIT_FLAG_TEX2_INV_RANDOM_V ) ) { if ( sysStripeRandom.z > 0.5 ) inUv2.y = -inUv2.y; }
#endif
#ifdef _PRIMITIVE
    if ( CHECK_BIT_FLAG( BIT_FLAG_TEX0_INV_RANDOM_U ) ) { if ( sysStripeRandom.x > 0.5 ) inUv0.x = 1.0 - inUv0.x; }
    if ( CHECK_BIT_FLAG( BIT_FLAG_TEX0_INV_RANDOM_V ) ) { if ( sysStripeRandom.y > 0.5 ) inUv0.y = 1.0 - inUv0.y; }
    if ( CHECK_BIT_FLAG( BIT_FLAG_TEX1_INV_RANDOM_U ) ) { if ( sysStripeRandom.z > 0.5 ) inUv1.x = 1.0 - inUv1.x; }
    if ( CHECK_BIT_FLAG( BIT_FLAG_TEX1_INV_RANDOM_V ) ) { if ( sysStripeRandom.w > 0.5 ) inUv1.y = 1.0 - inUv1.y; }
    if ( CHECK_BIT_FLAG( BIT_FLAG_TEX2_INV_RANDOM_U ) ) { if ( sysStripeRandom.y > 0.5 ) inUv2.x = 1.0 - inUv2.x; }
    if ( CHECK_BIT_FLAG( BIT_FLAG_TEX2_INV_RANDOM_V ) ) { if ( sysStripeRandom.z > 0.5 ) inUv2.y = 1.0 - inUv2.y; }
#endif

    // テクスチャ パターンアニメーション コマ値を計算
    ptclTexturePtn0 = ptclTexturePtn1 = ptclTexturePtn2 = 0;

    float life = 100;
    vec4 randomSeed = sysStripeRandom;

    vec3 texPtnRandomSeed;
    texPtnRandomSeed.x = texPtnRandomSeed.y = texPtnRandomSeed.z = randomSeed.x;

    // テクスチャ座標アニメーションを計算
    // 乱数を共有するかしないかの設定
    ivec3 texShareRandom = ivec3( 0, 0, 0 );
    if( !CHECK_BIT_FLAG_1( BIT_FLAG_TEX_ANIM_FIXED_RANDOM ) )
    {
        // 乱数を共有しない
        texShareRandom.y = 1;
        texShareRandom.z = 2;

        texPtnRandomSeed.x = randomSeed.x;
        texPtnRandomSeed.y = randomSeed.y;
        texPtnRandomSeed.z = randomSeed.z;
    }

#if 1
#ifdef _TEX_0_PATTERN_ANIM
    ptclTexturePtn0 = CalculateTexPtnAnim0( sysPtclTime, life, texPtnRandomSeed.x );
#endif
#ifdef _TEX_1_PATTERN_ANIM
    ptclTexturePtn1 = CalculateTexPtnAnim1( sysPtclTime, life, texPtnRandomSeed.y );
#endif
#ifdef _TEX_2_PATTERN_ANIM
    ptclTexturePtn2 = CalculateTexPtnAnim2( sysPtclTime, life, texPtnRandomSeed.z );
#endif
#endif

    vec2 animDir = vec2( -1, 1 );   // テクスチャのスクロール方向補正
    vec2 texBaseOffset = vec2( -0.5, 0.5 );
#if defined( _TEX_0_SHIFT_ANIM ) || defined( _TEX_0_PATTERN_ANIM ) || defined( _TEX_0_SHIFT_ANIM_ROTATE )
    outUv0 = CalculateTextureShiftAnimWithRotate( inUv0, texShiftAnim0, sysPtclTime, ptclTexturePtn0, texShareRandom.x, randomSeed );
    //outUv0.x -= 0.5;    // CalculateTextureShiftAnim 内で補正されたパーティクルテクスチャ座標を補正
    //outUv0.y -= 0.5;
#else
    outUv0.x = inUv0.x *  texShiftAnim0.pm4.x * ( 1 / texShiftAnim0.pm4.z );
    outUv0.y = inUv0.y * -texShiftAnim0.pm4.y * ( 1 / texShiftAnim0.pm4.w );
#endif

#if defined( _TEX_1_SHIFT_ANIM ) || defined( _TEX_1_PATTERN_ANIM ) || defined( _TEX_1_SHIFT_ANIM_ROTATE )
    outUv1 = CalculateTextureShiftAnimWithRotate( inUv1, texShiftAnim1, sysPtclTime, ptclTexturePtn1, texShareRandom.y, randomSeed );
    //outUv1.x -= 0.5;    // CalculateTextureShiftAnim 内で補正されたパーティクルテクスチャ座標を補正
    //outUv1.y -= 0.5;
#else
    outUv1.x = inUv1.x *  texShiftAnim1.pm4.x * ( 1 / texShiftAnim1.pm4.z );
    outUv1.y = inUv1.y * -texShiftAnim1.pm4.y * ( 1 / texShiftAnim1.pm4.w );
#endif

#if defined( _TEX_2_SHIFT_ANIM ) || defined( _TEX_2_PATTERN_ANIM ) || defined( _TEX_2_SHIFT_ANIM_ROTATE )
    outUv2 = CalculateTextureShiftAnimWithRotate( inUv2, texShiftAnim2, sysPtclTime, ptclTexturePtn2, texShareRandom.z, randomSeed );
    //outUv2.x -= 0.5;    // CalculateTextureShiftAnim 内で補正されたパーティクルテクスチャ座標を補正
    //outUv2.y -= 0.5;
#else
    outUv2.x = inUv2.x *  texShiftAnim2.pm4.x * ( 1 / texShiftAnim2.pm4.z );
    outUv2.y = inUv2.y * -texShiftAnim2.pm4.y * ( 1 / texShiftAnim2.pm4.w );
#endif

    // ピクセルシェーダでのスクリーン座標参照用
    sysFragCoordVary = sysTexCoordTransformMatrix * gl_Position;

    sysTexCoord01Vary.x = outUv0.x;
    sysTexCoord01Vary.y = outUv0.y;
    sysTexCoord01Vary.z = outUv1.x;
    sysTexCoord01Vary.w = outUv1.y;
    sysTexCoord2Vary.x  = outUv2.x;
    sysTexCoord2Vary.y  = outUv2.y;

    // パーティクルの中心のデプス値を計算
    sysPtclFragCoordCenter = sysTexCoordTransformMatrix * ( vec4( sysStripePointPos, 1 ) * sysViewProjectionMatrix );
    sysPtclVertexDepthValueCenter = GetDepthValue( sysPtclFragCoordCenter );

    sysPtclAlphaRate = 1.0;
    float nearDistAlphaRate = 1.0;
    float farDistAlphaRate = 1.0;

#ifndef _VFX_NSDK01215_COMPATIBLE
    //--------------------------------------------------------------
    // 遮蔽チェック処理
#ifdef RESERVED_SHADER_1
    // MEMO: 履歴式ストライプに限定。連結式ストライプは未対応。
#ifdef _MASKING_CHECK
    vec3 stripeHeadPos = sysStripeHeadPos;
    vec4 stripeHeadFragCoordCenter = sysTexCoordTransformMatrix * ( vec4( stripeHeadPos, 1 ) * sysViewProjectionMatrix );
    float stripeHeadDepthValue = GetDepthValue( stripeHeadFragCoordCenter );
    float maskAlphaRate = CalcMaskingCheck( stripeHeadFragCoordCenter, stripeHeadDepthValue );
    sysPtclAlphaRate *= maskAlphaRate;
#endif
#endif
#endif

    //--------------------------------------------------------------
    // 近距離アルファ
#ifdef _NEAR_DIST_ALPHA
#define nearAlphaMin    alphaFunc1.x
#define nearAlphaMax    alphaFunc1.y
    nearDistAlphaRate = ( sysPtclVertexDepthValueCenter - nearAlphaMin ) / ( nearAlphaMax - nearAlphaMin );
    nearDistAlphaRate = clamp( nearDistAlphaRate, 0.0, 1.0 );
    sysPtclAlphaRate *= nearDistAlphaRate;
#endif

    //--------------------------------------------------------------
    // 遠距離アルファ
#ifdef _FAR_DIST_ALPHA
#define farAlphaMin    alphaFunc1.z
#define farAlphaMax    alphaFunc1.w
    farDistAlphaRate = ( sysPtclVertexDepthValueCenter - farAlphaMin ) / ( farAlphaMax - farAlphaMin );
    farDistAlphaRate = clamp( farDistAlphaRate, 0, 1 );
    farDistAlphaRate = 1 - farDistAlphaRate;
    sysPtclAlphaRate *= farDistAlphaRate;
#endif

    //--------------------------------------------------------------
    // フレネル処理
#ifdef _VERTEX_FRESNEL_ALPHA
    float fresnel = CalcFresnelRate( sysEyeVecVary.xyz, sysWorldNormalVary );
    sysPtclAlphaRate *= fresnel;
#endif

    //--------------------------------------------------------------
    // マスターアルファ値を計算
    float alphaPos = sysStripePointID / ( sysStripePointSum - 1 );
    sysMasterAlpha = alphaPos * ( sysStripeTailAlpha - sysStripeHeadAlpha ) + sysStripeHeadAlpha;
    sysMasterAlpha *= sysPtclAlphaRate * sysEmitterFadeAlpha;

    //--------------------------------------------------------------
    // 寿命係数
    sysLifeRatio = sysStripeTime / sysStripeLife;

    //--------------------------------------------------------------
    // シェーダアニメーションを計算
#if defined( _SHADER_ANIM ) || defined( _VFX_COMBINER_SHADER_ANIM_ENABLED )
    vec3 vShaderAnim = Calculate8KeyAnimShader( shaderAnimKeyNum, sysStripeTime, 0, 0, sysStripeLife, sysStripeRandom.x ).xyz;
    sysShaderAnim  = vShaderAnim.x;
    sysShaderAnimY = vShaderAnim.y;
    sysShaderAnimZ = vShaderAnim.z;
#else
    sysShaderAnim  = shaderAnim.v[0].x;
    sysShaderAnimY = shaderAnim.v[0].y;
    sysShaderAnimZ = shaderAnim.v[0].z;
#endif

    // 乱数をフラグメントシェーダに送る
    sysParticleRandom = sysStripeRandom;

    //--------------------------------------------------------------
    // カスタムシェーダ処理
    //--------------------------------------------------------------
    FinalAdjustmentVertexProcess();

#ifdef _TARGET_VK
    gl_Position.y = -gl_Position.y;      // For Vulkan.
    #ifdef _DEPTH_MODE_NEAR_IS_MINUS_W
    gl_Position.z = (gl_Position.z + gl_Position.w) / 2.0;
    #endif
#endif
}


