﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// モデルトランスフォーム.
    /// </summary>
    [Serializable]
    public class ModelTransformUserData : UserDataBase
    {
        /// <summary>
        /// 座標.
        /// </summary>
        private Vector3f offsetPosition = null;

        /// <summary>
        /// スケール.
        /// </summary>
        private Vector3f offsetScale = null;

        /// <summary>
        /// 回転X, Y, Z
        /// </summary>
        private Vector3f offsetRotation = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ModelTransformUserData() :
            base()
        {
            this.ModelGuid = System.Guid.Empty;
            this.OffsetScale = new Vector3f(1.0f, 1.0f, 1.0f);
            this.OffsetRotation = new Vector3f(0.0f, 0.0f, 0.0f);

            this.PostConstruct();
        }

        /// <summary>
        /// 行列タイプ
        /// </summary>
        [DataModelPropertyGuid("fade499a-13d7-42c5-87cf-5d70ab08e1f8")]
        public int MatrixSetType { get; set; }

        /// <summary>
        /// 行列適用タイプ
        /// </summary>
        [DataModelPropertyGuid("9f7b1132-2c5c-4575-b733-d293c4e93873")]
        public int MatrixApplyType { get; set; }

        /// <summary>
        /// モデルのGUIDです。
        /// </summary>
        [DataModelPropertyGuid("336f076b-b133-4f71-89b0-c548abc5278a")]
        public Guid ModelGuid { get; set; }

        /// <summary>
        /// ボーンインデックス
        /// </summary>
        [DataModelPropertyGuid("9ef7dc2c-aea8-4b8b-a4a3-5ec11c4b0eab")]
        public int BoneIndex { get; set; }

        /// <summary>
        /// 座標.
        /// </summary>
        [DataModelPropertyGuid("b414fb74-612e-4007-86bd-c75fdb2c825c")]
        public Vector3f OffsetPosition
        {
            get { return this.GetObjectFromField(ref this.offsetPosition, false); }
            set { this.SetISettableToField(ref this.offsetPosition, value); }
        }

        /// <summary>
        /// スケール.
        /// </summary>
        [DataModelPropertyGuid("e0875af1-a6d0-4c99-8e4c-32b1ecc3a70b")]
        public Vector3f OffsetScale
        {
            get { return this.GetObjectFromField(ref this.offsetScale, false); }
            set { this.SetISettableToField(ref this.offsetScale, value); }
        }

        /// <summary>
        /// エミッタビルボードか否か
        /// </summary>
        [DataModelPropertyGuid("616d566d-a462-497d-80c0-49c9ef5cc4e6")]
        public bool IsEmitterBillboard { get; set; }

        /// <summary>
        /// モデルインデックス
        /// </summary>
        [DataModelPropertyGuid("d4ad75ef-113c-4af6-a597-1a97e4033f65")]
        public int ModelIndex { get; set; }

        /// <summary>
        /// 回転X, Y, Z
        /// </summary>
        [DataModelPropertyGuid("025d0153-21e4-4601-8692-dc79730120db")]
        public Vector3f OffsetRotation
        {
            get { return this.GetObjectFromField(ref this.offsetRotation, false); }
            set { this.SetISettableToField(ref this.offsetRotation, value); }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ModelTransformUserData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.MatrixSetType = srcDataModel.MatrixSetType;
            this.MatrixApplyType = srcDataModel.MatrixApplyType;
            this.ModelGuid = srcDataModel.ModelGuid;
            this.BoneIndex = srcDataModel.BoneIndex;
            this.OffsetPosition = srcDataModel.OffsetPosition;
            this.OffsetScale = srcDataModel.OffsetScale;
            this.IsEmitterBillboard = srcDataModel.IsEmitterBillboard;
            this.ModelIndex = srcDataModel.ModelIndex;
            this.OffsetRotation = srcDataModel.OffsetRotation;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "MatrixSetType", this.MatrixSetType);
            this.WriteElement(context, "MatrixApplyType", this.MatrixApplyType);
            this.WriteElement(context, "ModelGuid", this.ModelGuid);
            this.WriteElement(context, "BoneIndex", this.BoneIndex);
            this.WriteElement(context, "OffsetPosition", this.OffsetPosition);
            this.WriteElement(context, "OffsetScale", this.OffsetScale);
            this.WriteElement(context, "IsEmitterBillboard", this.IsEmitterBillboard);
            this.WriteElement(context, "ModelIndex", this.ModelIndex);
            this.WriteElement(context, "OffsetRotation", this.OffsetRotation);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.MatrixSetType = this.ReadElement(context, "MatrixSetType", this.MatrixSetType);
            this.MatrixApplyType = this.ReadElement(context, "MatrixApplyType", this.MatrixApplyType);
            this.ModelGuid = this.ReadElement(context, "ModelGuid", this.ModelGuid);
            this.BoneIndex = this.ReadElement(context, "BoneIndex", this.BoneIndex);
            this.OffsetPosition = this.ReadElement(context, "OffsetPosition", this.OffsetPosition);
            this.OffsetScale = this.ReadElement(context, "OffsetScale", this.OffsetScale);
            this.IsEmitterBillboard = this.ReadElement(context, "IsEmitterBillboard", this.IsEmitterBillboard);
            this.ModelIndex = this.ReadElement(context, "ModelIndex", this.ModelIndex);
            this.OffsetRotation = this.ReadElement(context, "OffsetRotation", this.OffsetRotation);

            return success;
        }
    }
}
