﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using ComboBoxItemType = System.Collections.Generic.KeyValuePair<string, object>;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// モデル自動移動.
    /// </summary>
    [Serializable]
    public class ModelAutoMoveUserData : UserDataBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public ModelAutoMoveUserData() :
            base()
        {
            this.MoveType = 0;
            this.RadiusXZ = 8.0f;
            this.SpeedXZ = 1.0f;
            this.MoveDistance = 20.0f;
            this.MoveSpeed = 1.0f;
            this.AmplitudeY = 0.0f;
            this.SpeedY = 5.0f;
            this.RollZ = 0.0f;
            this.StraightDirection = 90.0f;
            this.StraightAngle = 0.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// 自動移動タイプ.
        /// </summary>
        [DataModelPropertyGuid("40e44ebf-b805-4b77-b052-0c8ea00550fe")]
        public int MoveType { get; set; }

        /// <summary>
        /// XZ移動半径.
        /// </summary>
        [DataModelPropertyGuid("d861c06c-f647-48bf-9cd2-468adb53cdb3")]
        public float RadiusXZ { get; set; }

        /// <summary>
        /// XZ移動速度.
        /// </summary>
        [DataModelPropertyGuid("f792e225-b8fd-4ab5-842f-214154d3edcf")]
        public float SpeedXZ { get; set; }

        /// <summary>
        /// 移動距離
        /// </summary>
        [DataModelPropertyGuid("0d22d6c8-d1ab-4545-9796-4ae6c269584f")]
        public float MoveDistance { get; set; }

        /// <summary>
        /// 移動速度
        /// </summary>
        [DataModelPropertyGuid("b312fb17-ae23-416e-a0d2-5bf42b43b10c")]
        public float MoveSpeed { get; set; }

        /// <summary>
        /// Y揺れ振幅.
        /// </summary>
        [DataModelPropertyGuid("6f615bc9-b669-42e1-99ed-41a8f0cd3472")]
        public float AmplitudeY { get; set; }

        /// <summary>
        /// Y揺れ速度.
        /// </summary>
        [DataModelPropertyGuid("a6a65de9-3ee4-4f54-a095-3ead5df7b7f7")]
        public float SpeedY { get; set; }

        /// <summary>
        /// Zロール速度.
        /// </summary>
        [DataModelPropertyGuid("a727438a-c5a0-41ed-9a44-b7e69d25ba1a")]
        public float RollZ { get; set; }

        /// <summary>
        /// 自動移動タイプアイテム.
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("afc40231-eeee-4d35-8766-5c4c2100a307")]
        public IEnumerable<ComboBoxItemType> MoveTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("UserDataModelAutoMoveComboBoxItemNothing"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("UserDataModelAutoMoveComboBoxItemMoveOnXZ"), 1),
                    new ComboBoxItemType(ResourceAccessor.GetString("UserDataModelAutoMoveComboBoxItemMoveStraight"), 2),
                };
            }
        }

        /// <summary>
        /// 水平方向角度
        /// </summary>
        [DataModelPropertyGuid("c086ddc0-3f7c-4c50-b04e-e021f357aefb")]
        public float StraightDirection { get; set; }

        /// <summary>
        /// 垂直方向角度
        /// </summary>
        [DataModelPropertyGuid("4ad7a2f6-a068-4637-9c67-bdff7fb6dca6")]
        public float StraightAngle { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.ModelAutoMoveUserData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.MoveType = srcDataModel.MoveType;
            this.RadiusXZ = srcDataModel.RadiusXZ;
            this.SpeedXZ = srcDataModel.SpeedXZ;
            this.MoveDistance = srcDataModel.MoveDistance;
            this.MoveSpeed = srcDataModel.MoveSpeed;
            this.AmplitudeY = srcDataModel.AmplitudeY;
            this.SpeedY = srcDataModel.SpeedY;
            this.RollZ = srcDataModel.RollZ;
            this.StraightDirection = srcDataModel.StraightDirection;
            this.StraightAngle = srcDataModel.StraightAngle;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "MoveType", this.MoveType);
            this.WriteElement(context, "RadiusXZ", this.RadiusXZ);
            this.WriteElement(context, "SpeedXZ", this.SpeedXZ);
            this.WriteElement(context, "MoveDistance", this.MoveDistance);
            this.WriteElement(context, "MoveSpeed", this.MoveSpeed);
            this.WriteElement(context, "AmplitudeY", this.AmplitudeY);
            this.WriteElement(context, "SpeedY", this.SpeedY);
            this.WriteElement(context, "RollZ", this.RollZ);
            this.WriteElement(context, "StraightDirection", this.StraightDirection);
            this.WriteElement(context, "StraightAngle", this.StraightAngle);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.MoveType = this.ReadElement(context, "MoveType", this.MoveType);
            this.RadiusXZ = this.ReadElement(context, "RadiusXZ", this.RadiusXZ);
            this.SpeedXZ = this.ReadElement(context, "SpeedXZ", this.SpeedXZ);
            this.MoveDistance = this.ReadElement(context, "MoveDistance", this.MoveDistance);
            this.MoveSpeed = this.ReadElement(context, "MoveSpeed", this.MoveSpeed);
            this.AmplitudeY = this.ReadElement(context, "AmplitudeY", this.AmplitudeY);
            this.SpeedY = this.ReadElement(context, "SpeedY", this.SpeedY);
            this.RollZ = this.ReadElement(context, "RollZ", this.RollZ);
            this.StraightDirection = this.ReadElement(context, "StraightDirection", this.StraightDirection);
            this.StraightAngle = this.ReadElement(context, "StraightAngle", this.StraightAngle);

            return success;
        }
    }
}
