﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using ComboBoxItemType = System.Collections.Generic.KeyValuePair<string, object>;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ストライプノード/履歴式タブ/履歴式ストライプ2グループデータです。
    /// </summary>
    [Serializable]
    public class EPStripeHistoryTailData : UserDataBase
    {
        /// <summary>
        /// 履歴の加速度を取得または設定します。
        /// </summary>
        private Vector3f historyAcceleration = null;

        /// <summary>
        /// 履歴の変化周期を取得または設定します。
        /// </summary>
        private Vector3f historyInitVecRotateCycle = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EPStripeHistoryTailData() :
            base()
        {
            this.StripeType = 0;
            this.FollowEmitter = false;
            this.Option = 0;
            this.TexCoordType = 0;
            this.TexCoordType1 = 0;
            this.TexCoordType2 = 0;
            this.NumHistory = 60.0f;
            this.ConnectionType = 0;
            this.StartSliceAlpha = 1.0f;
            this.EndSliceAlpha = 1.0f;
            this.NumDivisions = 0;
            this.TextureUVMapType = 0;
            this.HistInterpolation = 0.0f;
            this.DirInterpolation = 0.0f;
            this.HistoryTailVecRegulation = 0.0f;
            this.HistoryTailVecSpeed = 0.0f;
            this.HistoryAirRegist = 1.0f;
            this.HistoryAcceleration = new Vector3f(0.0f, 0.0f, 0.0f);
            this.HistoryInitVecRotateCycle = new Vector3f(1.0f, 1.0f, 1.0f);
            this.TestParam00 = 0.0f;
            this.TestParam01 = 0.0f;
            this.TestParam02 = 0.0f;
            this.TestParam03 = 0.0f;
            this.TestParam04 = 0.0f;
            this.TestParam05 = 0.0f;
            this.TestParam06 = 0.0f;
            this.TestParam07 = 0.0f;
            this.StartSliceScale = 1.0f;
            this.EndSliceScale = 1.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// 計算方法を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c070aa21-0026-4035-9211-d2651da33302")]
        public int StripeType { get; set; }

        /// <summary>
        /// エミッタに完全追従のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("e01a11c0-44a8-40e0-9220-d671f54fcdc8")]
        public bool FollowEmitter { get; set; }

        /// <summary>
        /// オプションの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("7108b928-d6f9-4a02-bf32-e26edec224f2")]
        public int Option { get; set; }

        /// <summary>
        /// テクスチャ0のテクスチャリングの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("b587e297-7eef-4c5a-9313-5950ddf9a190")]
        public int TexCoordType { get; set; }

        /// <summary>
        /// テクスチャ1のテクスチャリングの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("cba4bb9f-2370-472c-847b-e1c5e42814f2")]
        public int TexCoordType1 { get; set; }

        /// <summary>
        /// テクスチャ2のテクスチャリングの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("e3ae8cb3-2b53-4dd8-870a-234e09adea9c")]
        public int TexCoordType2 { get; set; }

        /// <summary>
        /// 履歴の長さを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("a1ed6417-a6ac-49d9-ae45-6e2c07dc26e8")]
        public float NumHistory { get; set; }

        /// <summary>
        /// 接続タイプを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("586a06a7-86bc-4095-b5b6-de38c38923ce")]
        public int ConnectionType { get; set; }

        /// <summary>
        /// 先端αの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("d9105b03-8cd6-489a-8ea8-712c2942c7c8")]
        public float StartSliceAlpha { get; set; }

        /// <summary>
        /// 末端αの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("94e6f99a-b76e-424d-9fb3-9bae709d947f")]
        public float EndSliceAlpha { get; set; }

        /// <summary>
        /// 分割数を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("4919ce4a-31fa-4858-ae96-0b70dd8db14f")]
        public int NumDivisions { get; set; }

        /// <summary>
        /// UV割り当ての種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("7aba10c6-0c7f-48aa-a3f2-d48a8352d965")]
        public int TextureUVMapType { get; set; }

        /// <summary>
        /// 履歴補間パラメータの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("fbf0c893-d03d-4c82-b334-2e8bd801930d")]
        public float HistInterpolation { get; set; }

        /// <summary>
        /// 方向補率を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("5af9f974-57b3-460a-afe6-2057bd625f5b")]
        public float DirInterpolation { get; set; }

        /// <summary>
        /// 方向変化率を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("894f0519-09b9-4c45-bd3d-56b6e5921f1b")]
        public float HistoryTailVecRegulation { get; set; }

        /// <summary>
        /// 履歴の初速を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("7aeb23e2-7c33-4c2f-bea2-f7917e4c86dc")]
        public float HistoryTailVecSpeed { get; set; }

        /// <summary>
        /// 履歴の空気抵抗の値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("4d77e84a-6572-46c8-b658-be73b718a9cc")]
        public float HistoryAirRegist { get; set; }

        /// <summary>
        /// 履歴の加速度を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c89457a8-7dc4-4eef-af51-2720a6b94f88")]
        public Vector3f HistoryAcceleration
        {
            get { return this.GetObjectFromField(ref this.historyAcceleration, false); }
            set { this.SetISettableToField(ref this.historyAcceleration, value); }
        }

        /// <summary>
        /// 履歴の変化周期を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("302442d6-599b-4726-ab76-9a250c426bdb")]
        public Vector3f HistoryInitVecRotateCycle
        {
            get { return this.GetObjectFromField(ref this.historyInitVecRotateCycle, false); }
            set { this.SetISettableToField(ref this.historyInitVecRotateCycle, value); }
        }

        /// <summary>
        /// 計算方法の選択肢を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("ba23af72-1476-4f39-8ec5-c63b792f9dc7")]
        public IEnumerable<ComboBoxItemType> StripeTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemBillboard"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemEmitterMatrix"), 1),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemEmitterTopBottom"), 2),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemRibbon"), 3),
                };
            }
        }

        /// <summary>
        /// オプションの選択肢を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("5d7c9180-9981-41f2-a88f-0d12e90d2183")]
        public IEnumerable<ComboBoxItemType> OptionTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemNormal"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemCross"), 1),
                };
            }
        }

        /// <summary>
        /// テクスチャリングの選択肢を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("13b0306e-105c-4624-9661-8e86adfc9c1e")]
        public IEnumerable<ComboBoxItemType> TexCoordTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemPutAll"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemPutFit"), 1),
                };
            }
        }

        /// <summary>
        /// 接続タイプの選択肢を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("a9324d77-133f-4348-b637-0e05ba1df66b")]
        public IEnumerable<ComboBoxItemType> ConnectionTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemConnectNormal"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemConnectTop"), 1),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemConnectEmitter"), 2),
                };
            }
        }

        /// <summary>
        /// UV割り当ての選択肢を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("96880e47-78b7-4f07-9deb-f8b5c63cf0bd")]
        public IEnumerable<ComboBoxItemType> StripeUVMapTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("EPHistoryStripe2ComboBoxItemFixRatio"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPHistoryStripe2ComboBoxItemDistance"), 1),
                };
            }
        }

        /// <summary>
        /// 実験用パラメータ
        /// </summary>
        [DataModelPropertyGuid("9d6e14dc-da8d-4f37-9026-8af632dc42c3")]
        public float TestParam00 { get; set; }

        /// <summary>
        /// 実験用パラメータ
        /// </summary>
        [DataModelPropertyGuid("dd5f60bf-0ec1-4ca6-9820-fcfc0183d22c")]
        public float TestParam01 { get; set; }

        /// <summary>
        /// 実験用パラメータ
        /// </summary>
        [DataModelPropertyGuid("1e395902-4918-454c-a3f4-42f2695e61ad")]
        public float TestParam02 { get; set; }

        /// <summary>
        /// 実験用パラメータ
        /// </summary>
        [DataModelPropertyGuid("55bbf7d8-9aad-48ed-8e2e-33b42b5b7234")]
        public float TestParam03 { get; set; }

        /// <summary>
        /// 実験用パラメータ
        /// </summary>
        [DataModelPropertyGuid("5b01e4f4-8c7a-4d99-8507-281b18301ec1")]
        public float TestParam04 { get; set; }

        /// <summary>
        /// 実験用パラメータ
        /// </summary>
        [DataModelPropertyGuid("1792c093-4f39-477b-b6ba-ae25e8d089a4")]
        public float TestParam05 { get; set; }

        /// <summary>
        /// 実験用パラメータ
        /// </summary>
        [DataModelPropertyGuid("75f014ad-be4d-4e9c-b393-d2d274bb0713")]
        public float TestParam06 { get; set; }

        /// <summary>
        /// 実験用パラメータ
        /// </summary>
        [DataModelPropertyGuid("249c9087-d74a-43da-9c47-7a1a70edb021")]
        public float TestParam07 { get; set; }

        /// <summary>
        /// 先端スケールの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("9be9437f-8873-4dad-ae6c-a2f3b5f07eb1")]
        public float StartSliceScale { get; set; }

        /// <summary>
        /// 末端スケールの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("e916fd59-81b2-48ba-9b11-8ad607857bb1")]
        public float EndSliceScale { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EPStripeHistoryTailData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.StripeType = srcDataModel.StripeType;
            this.FollowEmitter = srcDataModel.FollowEmitter;
            this.Option = srcDataModel.Option;
            this.TexCoordType = srcDataModel.TexCoordType;
            this.TexCoordType1 = srcDataModel.TexCoordType1;
            this.TexCoordType2 = srcDataModel.TexCoordType2;
            this.NumHistory = srcDataModel.NumHistory;
            this.ConnectionType = srcDataModel.ConnectionType;
            this.StartSliceAlpha = srcDataModel.StartSliceAlpha;
            this.EndSliceAlpha = srcDataModel.EndSliceAlpha;
            this.NumDivisions = srcDataModel.NumDivisions;
            this.TextureUVMapType = srcDataModel.TextureUVMapType;
            this.HistInterpolation = srcDataModel.HistInterpolation;
            this.DirInterpolation = srcDataModel.DirInterpolation;
            this.HistoryTailVecRegulation = srcDataModel.HistoryTailVecRegulation;
            this.HistoryTailVecSpeed = srcDataModel.HistoryTailVecSpeed;
            this.HistoryAirRegist = srcDataModel.HistoryAirRegist;
            this.HistoryAcceleration = srcDataModel.HistoryAcceleration;
            this.HistoryInitVecRotateCycle = srcDataModel.HistoryInitVecRotateCycle;
            this.TestParam00 = srcDataModel.TestParam00;
            this.TestParam01 = srcDataModel.TestParam01;
            this.TestParam02 = srcDataModel.TestParam02;
            this.TestParam03 = srcDataModel.TestParam03;
            this.TestParam04 = srcDataModel.TestParam04;
            this.TestParam05 = srcDataModel.TestParam05;
            this.TestParam06 = srcDataModel.TestParam06;
            this.TestParam07 = srcDataModel.TestParam07;
            this.StartSliceScale = srcDataModel.StartSliceScale;
            this.EndSliceScale = srcDataModel.EndSliceScale;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "StripeType", this.StripeType);
            this.WriteElement(context, "FollowEmitter", this.FollowEmitter);
            this.WriteElement(context, "Option", this.Option);
            this.WriteElement(context, "TexCoordType", this.TexCoordType);
            this.WriteElement(context, "TexCoordType1", this.TexCoordType1);
            this.WriteElement(context, "TexCoordType2", this.TexCoordType2);
            this.WriteElement(context, "NumHistory", this.NumHistory);
            this.WriteElement(context, "ConnectionType", this.ConnectionType);
            this.WriteElement(context, "StartSliceAlpha", this.StartSliceAlpha);
            this.WriteElement(context, "EndSliceAlpha", this.EndSliceAlpha);
            this.WriteElement(context, "NumDivisions", this.NumDivisions);
            this.WriteElement(context, "TextureUVMapType", this.TextureUVMapType);
            this.WriteElement(context, "HistInterpolation", this.HistInterpolation);
            this.WriteElement(context, "DirInterpolation", this.DirInterpolation);
            this.WriteElement(context, "HistoryTailVecRegulation", this.HistoryTailVecRegulation);
            this.WriteElement(context, "HistoryTailVecSpeed", this.HistoryTailVecSpeed);
            this.WriteElement(context, "HistoryAirRegist", this.HistoryAirRegist);
            this.WriteElement(context, "HistoryAcceleration", this.HistoryAcceleration);
            this.WriteElement(context, "HistoryInitVecRotateCycle", this.HistoryInitVecRotateCycle);
            this.WriteElement(context, "TestParam00", this.TestParam00);
            this.WriteElement(context, "TestParam01", this.TestParam01);
            this.WriteElement(context, "TestParam02", this.TestParam02);
            this.WriteElement(context, "TestParam03", this.TestParam03);
            this.WriteElement(context, "TestParam04", this.TestParam04);
            this.WriteElement(context, "TestParam05", this.TestParam05);
            this.WriteElement(context, "TestParam06", this.TestParam06);
            this.WriteElement(context, "TestParam07", this.TestParam07);
            this.WriteElement(context, "StartSliceScale", this.StartSliceScale);
            this.WriteElement(context, "EndSliceScale", this.EndSliceScale);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.StripeType = this.ReadElement(context, "StripeType", this.StripeType);
            this.FollowEmitter = this.ReadElement(context, "FollowEmitter", this.FollowEmitter);
            this.Option = this.ReadElement(context, "Option", this.Option);
            this.TexCoordType = this.ReadElement(context, "TexCoordType", this.TexCoordType);
            this.TexCoordType1 = this.ReadElement(context, "TexCoordType1", this.TexCoordType1);
            this.TexCoordType2 = this.ReadElement(context, "TexCoordType2", this.TexCoordType2);
            this.NumHistory = this.ReadElement(context, "NumHistory", this.NumHistory);
            this.ConnectionType = this.ReadElement(context, "ConnectionType", this.ConnectionType);
            this.StartSliceAlpha = this.ReadElement(context, "StartSliceAlpha", this.StartSliceAlpha);
            this.EndSliceAlpha = this.ReadElement(context, "EndSliceAlpha", this.EndSliceAlpha);
            this.NumDivisions = this.ReadElement(context, "NumDivisions", this.NumDivisions);
            this.TextureUVMapType = this.ReadElement(context, "TextureUVMapType", this.TextureUVMapType);
            this.HistInterpolation = this.ReadElement(context, "HistInterpolation", this.HistInterpolation);
            this.DirInterpolation = this.ReadElement(context, "DirInterpolation", this.DirInterpolation);
            this.HistoryTailVecRegulation = this.ReadElement(context, "HistoryTailVecRegulation", this.HistoryTailVecRegulation);
            this.HistoryTailVecSpeed = this.ReadElement(context, "HistoryTailVecSpeed", this.HistoryTailVecSpeed);
            this.HistoryAirRegist = this.ReadElement(context, "HistoryAirRegist", this.HistoryAirRegist);
            this.HistoryAcceleration = this.ReadElement(context, "HistoryAcceleration", this.HistoryAcceleration);
            this.HistoryInitVecRotateCycle = this.ReadElement(context, "HistoryInitVecRotateCycle", this.HistoryInitVecRotateCycle);
            this.TestParam00 = this.ReadElement(context, "TestParam00", this.TestParam00);
            this.TestParam01 = this.ReadElement(context, "TestParam01", this.TestParam01);
            this.TestParam02 = this.ReadElement(context, "TestParam02", this.TestParam02);
            this.TestParam03 = this.ReadElement(context, "TestParam03", this.TestParam03);
            this.TestParam04 = this.ReadElement(context, "TestParam04", this.TestParam04);
            this.TestParam05 = this.ReadElement(context, "TestParam05", this.TestParam05);
            this.TestParam06 = this.ReadElement(context, "TestParam06", this.TestParam06);
            this.TestParam07 = this.ReadElement(context, "TestParam07", this.TestParam07);
            this.StartSliceScale = this.ReadElement(context, "StartSliceScale", this.StartSliceScale);
            this.EndSliceScale = this.ReadElement(context, "EndSliceScale", this.EndSliceScale);

            return success;
        }
    }
}
