﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class EPStripeHistoryTailBinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>A flag to prevent the static constructor being called more than once.</summary>
        private static bool isStaticConstructorCalled = false;

        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static EPStripeHistoryTailBinaryConversionInfo()
        {
            if (isStaticConstructorCalled == true)
            {
                return;
            }

            isStaticConstructorCalled = true;

            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var ePStripeHistoryTailBinary = new BinaryStructDefinition(typeof(EPStripeHistoryTailData)) { HasBinaryHeader = false };

            // Output : calcType
            // Inputs : StripeType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("StripeType", new Guid("c070aa21-0026-4035-9211-d2651da33302"))
            );

            // Output : emitterFollow
            // Inputs : FollowEmitter
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (System.Int32)1) }),
                    new ConverterParam("DefaultOutput", (System.Int32)0)),
                null,
                new InputPropertyDefinition("FollowEmitter", new Guid("e01a11c0-44a8-40e0-9220-d671f54fcdc8"))
            );

            // Output : option
            // Inputs : Option
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Option", new Guid("7108b928-d6f9-4a02-bf32-e26edec224f2"))
            );

            // Output : texturing0
            // Inputs : TexCoordType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("TexCoordType", new Guid("b587e297-7eef-4c5a-9313-5950ddf9a190"))
            );

            // Output : texturing1
            // Inputs : TexCoordType1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("TexCoordType1", new Guid("cba4bb9f-2370-472c-847b-e1c5e42814f2"))
            );

            // Output : texturing2
            // Inputs : TexCoordType2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("TexCoordType2", new Guid("e3ae8cb3-2b53-4dd8-870a-234e09adea9c"))
            );

            // Output : numHistory
            // Inputs : NumHistory
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("NumHistory", new Guid("a1ed6417-a6ac-49d9-ae45-6e2c07dc26e8"))
            );

            // Output : connectionType
            // Inputs : ConnectionType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("ConnectionType", new Guid("586a06a7-86bc-4095-b5b6-de38c38923ce"))
            );

            // Output : headAlpha
            // Inputs : StartSliceAlpha
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("StartSliceAlpha", new Guid("d9105b03-8cd6-489a-8ea8-712c2942c7c8"))
            );

            // Output : tailAlpha
            // Inputs : EndSliceAlpha
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EndSliceAlpha", new Guid("94e6f99a-b76e-424d-9fb3-9bae709d947f"))
            );

            // Output : numDivide
            // Inputs : NumDivisions
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("NumDivisions", new Guid("4919ce4a-31fa-4858-ae96-0b70dd8db14f"))
            );

            // Output : histInterpolate
            // Inputs : HistInterpolation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("HistInterpolation", new Guid("fbf0c893-d03d-4c82-b334-2e8bd801930d"))
            );

            // Output : dirInterpolate
            // Inputs : DirInterpolation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("DirInterpolation", new Guid("5af9f974-57b3-460a-afe6-2057bd625f5b"))
            );

            // Output : historyAirRegist
            // Inputs : HistoryAirRegist
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("HistoryAirRegist", new Guid("4d77e84a-6572-46c8-b658-be73b718a9cc"))
            );

            // Output : historyAcceleration
            // Inputs : HistoryAcceleration
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("HistoryAcceleration", new Guid("c89457a8-7dc4-4eef-af51-2720a6b94f88"))
            );

            // Output : historyVecRegulation
            // Inputs : HistoryTailVecRegulation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("HistoryTailVecRegulation", new Guid("894f0519-09b9-4c45-bd3d-56b6e5921f1b"))
            );

            // Output : historyVecInitSpeed
            // Inputs : HistoryTailVecSpeed
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("HistoryTailVecSpeed", new Guid("7aeb23e2-7c33-4c2f-bea2-f7917e4c86dc"))
            );

            // Output : historyInitVecRotateCycle
            // Inputs : HistoryInitVecRotateCycle
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("HistoryInitVecRotateCycle", new Guid("302442d6-599b-4726-ab76-9a250c426bdb"))
            );

            // Output : textureUvMapType
            // Inputs : TextureUVMapType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("TextureUVMapType", new Guid("7aba10c6-0c7f-48aa-a3f2-d48a8352d965"))
            );

            // Output : headScale
            // Inputs : StartSliceScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("StartSliceScale", new Guid("9be9437f-8873-4dad-ae6c-a2f3b5f07eb1"))
            );

            // Output : tailScale
            // Inputs : EndSliceScale
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EndSliceScale", new Guid("e916fd59-81b2-48ba-9b11-8ad607857bb1"))
            );

            // Output : test00
            // Inputs : TestParam00
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("TestParam00", new Guid("9d6e14dc-da8d-4f37-9026-8af632dc42c3"))
            );

            // Output : test01
            // Inputs : TestParam01
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("TestParam01", new Guid("dd5f60bf-0ec1-4ca6-9820-fcfc0183d22c"))
            );

            // Output : test02
            // Inputs : TestParam02
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("TestParam02", new Guid("1e395902-4918-454c-a3f4-42f2695e61ad"))
            );

            // Output : test03
            // Inputs : TestParam03
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("TestParam03", new Guid("55bbf7d8-9aad-48ed-8e2e-33b42b5b7234"))
            );

            // Output : test04
            // Inputs : TestParam04
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("TestParam04", new Guid("5b01e4f4-8c7a-4d99-8507-281b18301ec1"))
            );

            // Output : test05
            // Inputs : TestParam05
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("TestParam05", new Guid("1792c093-4f39-477b-b6ba-ae25e8d089a4"))
            );

            // Output : test06
            // Inputs : TestParam06
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("TestParam06", new Guid("75f014ad-be4d-4e9c-b393-d2d274bb0713"))
            );

            // Output : test07
            // Inputs : TestParam07
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryTailBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("TestParam07", new Guid("249c9087-d74a-43da-9c47-7a1a70edb021"))
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = ePStripeHistoryTailBinary;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private EPStripeHistoryTailBinaryConversionInfo(DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }
    }
}
