﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using ComboBoxItemType = System.Collections.Generic.KeyValuePair<string, object>;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// ストライプノード/履歴式タブ/履歴式ストライプグループデータです。
    /// </summary>
    [Serializable]
    public class EPStripeHistoryData : UserDataBase
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EPStripeHistoryData() :
            base()
        {
            this.StripeType = 0;
            this.FollowEmitter = false;
            this.Option = 0;
            this.TexCoordType = 0;
            this.NumDivisions = 0.0f;
            this.StripeLength = 60.0f;
            this.SliceLength = 0.0f;
            this.StartSliceAlpha = 1.0f;
            this.EndSliceAlpha = 1.0f;
            this.HistInterpolation = 0.0f;
            this.DirInterpolation = 0.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// 計算方法を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("5988c786-c9ca-4ca0-9d10-b104ad36cb55")]
        public int StripeType { get; set; }

        /// <summary>
        /// エミッタに完全追従のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("7d0ecf7f-4ae0-431e-9a34-953e32f29833")]
        public bool FollowEmitter { get; set; }

        /// <summary>
        /// オプションの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("5a4c64c7-7850-4bdd-ba93-ee87a3748c3a")]
        public int Option { get; set; }

        /// <summary>
        /// テクスチャリングの種類を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("afe1c153-6e54-4422-be0e-1c69c4dffb90")]
        public int TexCoordType { get; set; }

        /// <summary>
        /// 分割数を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("6dc07b4e-d038-47dd-a227-91a7f7146581")]
        public float NumDivisions { get; set; }

        /// <summary>
        /// 履歴数（ストライプの長さ）を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("a6c70864-83b1-461d-97b3-f855a2b32659")]
        public float StripeLength { get; set; }

        /// <summary>
        /// 履歴ポリゴン化の間隔を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("e6059584-8f4f-4468-b531-7518aad5be03")]
        public float SliceLength { get; set; }

        /// <summary>
        /// 先端αの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("13e632c4-995c-4ba3-a4a6-b17691fc464b")]
        public float StartSliceAlpha { get; set; }

        /// <summary>
        /// 末端αの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("e0dd1689-c6a6-483a-aab7-0eff4d27da35")]
        public float EndSliceAlpha { get; set; }

        /// <summary>
        /// 履歴補間パラメータの値を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("5b2153c8-8fd7-46c9-8bee-a9d2e35eb2f0")]
        public float HistInterpolation { get; set; }

        /// <summary>
        /// 方向補間率を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("cc15223a-dd05-44b6-ad68-4f6013783ae8")]
        public float DirInterpolation { get; set; }

        /// <summary>
        /// 計算方法の選択しを取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("2f0c5fae-b078-4fb9-b1e7-ba4b041e10a0")]
        public IEnumerable<ComboBoxItemType> StripeTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemBillboard"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemEmitterMatrix"), 1),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemEmitterTopBottom"), 2),
                };

            }
        }

        /// <summary>
        /// オプションの選択肢を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("9ad31b5e-e8a5-464b-82f3-0aeeb3c832cb")]
        public IEnumerable<ComboBoxItemType> OptionTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemNormal"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemCross"), 1),
                };
            }
        }

        /// <summary>
        /// テクスチャリングの選択肢を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("c70d02e0-7460-4a0b-8da0-1af3f9966edc")]
        public IEnumerable<ComboBoxItemType> TexCoordTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemPutAll"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemPutFit"), 1),
                };
            }
        }

        /// <summary>
        /// 接続タイプの選択肢を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("3e3ab2c3-c01c-4842-a171-c4437ad7bc9c")]
        public IEnumerable<ComboBoxItemType> ConnectionTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemConnectNormal"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemConnectTop"), 1),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPStripeComboBoxItemConnectEmitter"), 2),
                };

            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EPStripeHistoryData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.StripeType = srcDataModel.StripeType;
            this.FollowEmitter = srcDataModel.FollowEmitter;
            this.Option = srcDataModel.Option;
            this.TexCoordType = srcDataModel.TexCoordType;
            this.NumDivisions = srcDataModel.NumDivisions;
            this.StripeLength = srcDataModel.StripeLength;
            this.SliceLength = srcDataModel.SliceLength;
            this.StartSliceAlpha = srcDataModel.StartSliceAlpha;
            this.EndSliceAlpha = srcDataModel.EndSliceAlpha;
            this.HistInterpolation = srcDataModel.HistInterpolation;
            this.DirInterpolation = srcDataModel.DirInterpolation;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "StripeType", this.StripeType);
            this.WriteElement(context, "FollowEmitter", this.FollowEmitter);
            this.WriteElement(context, "Option", this.Option);
            this.WriteElement(context, "TexCoordType", this.TexCoordType);
            this.WriteElement(context, "NumDivisions", this.NumDivisions);
            this.WriteElement(context, "StripeLength", this.StripeLength);
            this.WriteElement(context, "SliceLength", this.SliceLength);
            this.WriteElement(context, "StartSliceAlpha", this.StartSliceAlpha);
            this.WriteElement(context, "EndSliceAlpha", this.EndSliceAlpha);
            this.WriteElement(context, "HistInterpolation", this.HistInterpolation);
            this.WriteElement(context, "DirInterpolation", this.DirInterpolation);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.StripeType = this.ReadElement(context, "StripeType", this.StripeType);
            this.FollowEmitter = this.ReadElement(context, "FollowEmitter", this.FollowEmitter);
            this.Option = this.ReadElement(context, "Option", this.Option);
            this.TexCoordType = this.ReadElement(context, "TexCoordType", this.TexCoordType);
            this.NumDivisions = this.ReadElement(context, "NumDivisions", this.NumDivisions);
            this.StripeLength = this.ReadElement(context, "StripeLength", this.StripeLength);
            this.SliceLength = this.ReadElement(context, "SliceLength", this.SliceLength);
            this.StartSliceAlpha = this.ReadElement(context, "StartSliceAlpha", this.StartSliceAlpha);
            this.EndSliceAlpha = this.ReadElement(context, "EndSliceAlpha", this.EndSliceAlpha);
            this.HistInterpolation = this.ReadElement(context, "HistInterpolation", this.HistInterpolation);
            this.DirInterpolation = this.ReadElement(context, "DirInterpolation", this.DirInterpolation);

            return success;
        }
    }
}
