﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class EPStripeHistoryBinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>A flag to prevent the static constructor being called more than once.</summary>
        private static bool isStaticConstructorCalled = false;

        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static EPStripeHistoryBinaryConversionInfo()
        {
            if (isStaticConstructorCalled == true)
            {
                return;
            }

            isStaticConstructorCalled = true;

            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var ePStripeHistoryBinary = new BinaryStructDefinition(typeof(EPStripeHistoryData)) { HasBinaryHeader = false };

            // Output : calcType
            // Inputs : StripeType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("StripeType", new Guid("5988c786-c9ca-4ca0-9d10-b104ad36cb55"))
            );

            // Output : emitterFollow
            // Inputs : FollowEmitter
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(SwitchCaseConverter),
                    new ConverterParam("Cases", new SwitchCase[] { new SwitchCase(true, (System.Int32)1) }),
                    new ConverterParam("DefaultOutput", (System.Int32)0)),
                null,
                new InputPropertyDefinition("FollowEmitter", new Guid("7d0ecf7f-4ae0-431e-9a34-953e32f29833"))
            );

            // Output : option
            // Inputs : Option
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Option", new Guid("5a4c64c7-7850-4bdd-ba93-ee87a3748c3a"))
            );

            // Output : texturing
            // Inputs : TexCoordType
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryBinary,
                SendModificationTypes.FullBinary,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("TexCoordType", new Guid("afe1c153-6e54-4422-be0e-1c69c4dffb90"))
            );

            // Output : numDivide
            // Inputs : NumDivisions
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("NumDivisions", new Guid("6dc07b4e-d038-47dd-a227-91a7f7146581"))
            );

            // Output : numHistory
            // Inputs : StripeLength
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryBinary,
                SendModificationTypes.ModifiedWithReset,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("StripeLength", new Guid("a6c70864-83b1-461d-97b3-f855a2b32659"))
            );

            // Output : interval
            // Inputs : SliceLength
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("SliceLength", new Guid("e6059584-8f4f-4468-b531-7518aad5be03"))
            );

            // Output : headAlpha
            // Inputs : StartSliceAlpha
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("StartSliceAlpha", new Guid("13e632c4-995c-4ba3-a4a6-b17691fc464b"))
            );

            // Output : tailAlpha
            // Inputs : EndSliceAlpha
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("EndSliceAlpha", new Guid("e0dd1689-c6a6-483a-aab7-0eff4d27da35"))
            );

            // Output : histInterpolate
            // Inputs : HistInterpolation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("HistInterpolation", new Guid("5b2153c8-8fd7-46c9-8bee-a9d2e35eb2f0"))
            );

            // Output : dirInterpolate
            // Inputs : DirInterpolation
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                ePStripeHistoryBinary,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("DirInterpolation", new Guid("cc15223a-dd05-44b6-ad68-4f6013783ae8"))
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = ePStripeHistoryBinary;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private EPStripeHistoryBinaryConversionInfo(DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }
    }
}
