﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using ComboBoxItemType = System.Collections.Generic.KeyValuePair<string, object>;
using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic;
using EffectMaker.Foundation.Primitives;
using EffectMaker.Foundation.Serialization;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// 範囲内ループノードデータです。
    /// </summary>
    [Serializable]
    public class EPAreaLoopData : UserDataBase
    {
        /// <summary>
        /// 箱の大きさを取得または設定します。
        /// </summary>
        private Vector3f areaSize = null;

        /// <summary>
        /// 箱の回転量を取得または設定します。
        /// この値はDegreeで指定します。
        /// </summary>
        private Vector3f areaRotate = null;

        /// <summary>
        /// 箱の位置を取得または設定します。
        /// </summary>
        private Vector3f areaPos = null;

        /// <summary>
        /// 端でアルファを薄くする割合を取得または設定します。
        /// </summary>
        private Vector3f alphaRatio = null;

        /// <summary>
        /// リピート毎のオフセットを取得または設定します。
        /// </summary>
        private Vector3f repeatOffsetPos = null;

        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public EPAreaLoopData() :
            base()
        {
            this.AreaSize = new Vector3f(100.0f, 100.0f, 100.0f);
            this.AreaRotate = new Vector3f(0.0f, 0.0f, 0.0f);
            this.AreaPos = new Vector3f(0.0f, 0.0f, 0.0f);
            this.AlphaRatio = new Vector3f(0.0f, 0.0f, 0.0f);
            this.RepeatNum = 0.0f;
            this.RepeatOffsetPos = new Vector3f(0.0f, 0.0f, 0.0f);
            this.IsCameraLoop = false;
            this.ClippingType = 0;
            this.ClippingWorldHeight = 0.0f;

            this.PostConstruct();
        }

        /// <summary>
        /// 箱の大きさを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("c2e42fad-3d6c-4fcd-9062-705eece96da8")]
        public Vector3f AreaSize
        {
            get { return this.GetObjectFromField(ref this.areaSize, false); }
            set { this.SetISettableToField(ref this.areaSize, value); }
        }

        /// <summary>
        /// 箱の回転量を取得または設定します。
        /// この値はDegreeで指定します。
        /// </summary>
        [DataModelPropertyGuid("32bc5ab1-91fc-47c6-8048-1ed4d523cbd2")]
        public Vector3f AreaRotate
        {
            get { return this.GetObjectFromField(ref this.areaRotate, false); }
            set { this.SetISettableToField(ref this.areaRotate, value); }
        }

        /// <summary>
        /// 箱の位置を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("cb199e6c-11ae-41b1-aa14-eebb679c3416")]
        public Vector3f AreaPos
        {
            get { return this.GetObjectFromField(ref this.areaPos, false); }
            set { this.SetISettableToField(ref this.areaPos, value); }
        }

        /// <summary>
        /// 端でアルファを薄くする割合を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("874653a2-ad6b-4ed9-b883-ffd8bca08146")]
        public Vector3f AlphaRatio
        {
            get { return this.GetObjectFromField(ref this.alphaRatio, false); }
            set { this.SetISettableToField(ref this.alphaRatio, value); }
        }

        /// <summary>
        /// リピート数を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("3bc9bf0e-2b0e-42a8-b095-82805b00003a")]
        public float RepeatNum { get; set; }

        /// <summary>
        /// リピート毎のオフセットを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("0c2298ee-b985-4a72-b727-4256e0d2a716")]
        public Vector3f RepeatOffsetPos
        {
            get { return this.GetObjectFromField(ref this.repeatOffsetPos, false); }
            set { this.SetISettableToField(ref this.repeatOffsetPos, value); }
        }

        /// <summary>
        /// 範囲をカメラ前に固定のOn/Offを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("15285afb-b4ce-4a9e-b5f0-f209caf4b3ee")]
        public bool IsCameraLoop { get; set; }

        /// <summary>
        /// クリッピング設定を取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("1d640c35-2e48-492d-b1d8-2022d89369d4")]
        public int ClippingType { get; set; }

        /// <summary>
        /// クリッピング平面の高さを取得または設定します。
        /// </summary>
        [DataModelPropertyGuid("bcd38ccb-8bc3-45ea-a976-25f4a7a4034d")]
        public float ClippingWorldHeight { get; set; }

        /// <summary>
        /// クリッピング設定の選択肢を取得します。
        /// </summary>
        [XmlIgnore]
        [DataModelPropertyGuid("06af4d64-ab05-4b5d-8b25-11076ab9c58c")]
        public IEnumerable<ComboBoxItemType> ClippingTypeItems
        {
            get
            {
                return new ComboBoxItemType[]
                {
                    new ComboBoxItemType(ResourceAccessor.GetString("EPAreaLoopComboBoxItemNoClip"), 0),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPAreaLoopComboBoxItemClipTop"), 1),
                    new ComboBoxItemType(ResourceAccessor.GetString("EPAreaLoopComboBoxItemClipBottom"), 2),
                };
            }
        }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.EPAreaLoopData;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.AreaSize = srcDataModel.AreaSize;
            this.AreaRotate = srcDataModel.AreaRotate;
            this.AreaPos = srcDataModel.AreaPos;
            this.AlphaRatio = srcDataModel.AlphaRatio;
            this.RepeatNum = srcDataModel.RepeatNum;
            this.RepeatOffsetPos = srcDataModel.RepeatOffsetPos;
            this.IsCameraLoop = srcDataModel.IsCameraLoop;
            this.ClippingType = srcDataModel.ClippingType;
            this.ClippingWorldHeight = srcDataModel.ClippingWorldHeight;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "AreaSize", this.AreaSize);
            this.WriteElement(context, "AreaRotate", this.AreaRotate);
            this.WriteElement(context, "AreaPos", this.AreaPos);
            this.WriteElement(context, "AlphaRatio", this.AlphaRatio);
            this.WriteElement(context, "RepeatNum", this.RepeatNum);
            this.WriteElement(context, "RepeatOffsetPos", this.RepeatOffsetPos);
            this.WriteElement(context, "IsCameraLoop", this.IsCameraLoop);
            this.WriteElement(context, "ClippingType", this.ClippingType);
            this.WriteElement(context, "ClippingWorldHeight", this.ClippingWorldHeight);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.AreaSize = this.ReadElement(context, "AreaSize", this.AreaSize);
            this.AreaRotate = this.ReadElement(context, "AreaRotate", this.AreaRotate);
            this.AreaPos = this.ReadElement(context, "AreaPos", this.AreaPos);
            this.AlphaRatio = this.ReadElement(context, "AlphaRatio", this.AlphaRatio);
            this.RepeatNum = this.ReadElement(context, "RepeatNum", this.RepeatNum);
            this.RepeatOffsetPos = this.ReadElement(context, "RepeatOffsetPos", this.RepeatOffsetPos);
            this.IsCameraLoop = this.ReadElement(context, "IsCameraLoop", this.IsCameraLoop);
            this.ClippingType = this.ReadElement(context, "ClippingType", this.ClippingType);
            this.ClippingWorldHeight = this.ReadElement(context, "ClippingWorldHeight", this.ClippingWorldHeight);

            return success;
        }
    }
}
