﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class CustomActionSetting4BinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static CustomActionSetting4BinaryConversionInfo()
        {
            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var customActionSetting4BinaryData = new BinaryStructDefinition(typeof(CustomActionSetting4)) { HasBinaryHeader = true };

            // Output : flag0
            // Inputs : Flag0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Flag0", new Guid("e6ed9f66-e553-4a45-b053-72ebfc5e584a"))
            );

            // Output : intParam0
            // Inputs : IntParam0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam0", new Guid("cc2bddab-2a5e-444e-af75-50bee041d35b"))
            );

            // Output : intParam1
            // Inputs : IntParam1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam1", new Guid("a321ffdc-5de0-40db-8d15-fa4885907e5d"))
            );

            // Output : intParam2
            // Inputs : IntParam2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam2", new Guid("a5c83131-c1d4-4f1a-a885-33284e009a6a"))
            );

            // Output : intParam3
            // Inputs : IntParam3
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam3", new Guid("6438b80e-7579-40d7-9b29-932dcbc63492"))
            );

            // Output : intParam4
            // Inputs : IntParam4
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam4", new Guid("31f2607f-e293-4d0d-bb0c-784e4f6cc42f"))
            );

            // Output : intParam5
            // Inputs : IntParam5
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam5", new Guid("521f6aab-0a4c-4f9e-baac-b62318a9c52c"))
            );

            // Output : floatParam0
            // Inputs : FloatParam0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam0", new Guid("ab690bd5-43c1-4a97-b889-444e9122f16b"))
            );

            // Output : floatParam1
            // Inputs : FloatParam1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam1", new Guid("07d267ef-1c15-4d0b-a5dc-c552495e9d6c"))
            );

            // Output : floatParam2
            // Inputs : FloatParam2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam2", new Guid("ab0bd5b5-7df3-42f2-a22b-7dde60e8ef26"))
            );

            // Output : floatParam3
            // Inputs : FloatParam3
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam3", new Guid("7bd34a70-bbd1-4345-9d09-68fdb0bd2052"))
            );

            // Output : floatParam4
            // Inputs : FloatParam4
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam4", new Guid("89befaa0-6ab8-4d33-9102-de76bd90d3d0"))
            );

            // Output : floatParam5
            // Inputs : FloatParam5
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam5", new Guid("50243368-0604-4460-a0b9-e9fc4b46c9b7"))
            );

            // Output : floatParam6
            // Inputs : FloatParam6
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam6", new Guid("a1e32014-7d1f-44ed-8d26-e97a785ee071"))
            );

            // Output : floatParam7
            // Inputs : FloatParam7
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting4BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam7", new Guid("86937719-ab7f-4909-b7e3-db0828d52253"))
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = customActionSetting4BinaryData;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private CustomActionSetting4BinaryConversionInfo(DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }
    }
}
