﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class CustomActionSetting0BinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static CustomActionSetting0BinaryConversionInfo()
        {
            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var customActionSetting0BinaryData = new BinaryStructDefinition(typeof(CustomActionSetting0)) { HasBinaryHeader = true };

            // Output : flag0
            // Inputs : Flag0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Flag0", new Guid("dfa5cb8e-3a0e-4f4b-bf03-0fce74d25b55"))
            );

            // Output : intParam0
            // Inputs : IntParam0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam0", new Guid("aaf925d1-402a-4ef1-adbb-24310e6629cc"))
            );

            // Output : intParam1
            // Inputs : IntParam1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam1", new Guid("b1db8c2d-83c6-40de-bfd7-3b277745352f"))
            );

            // Output : intParam2
            // Inputs : IntParam2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam2", new Guid("57d8fdb6-1c7b-4248-a72d-e6ad28c5ee05"))
            );

            // Output : intParam3
            // Inputs : IntParam3
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam3", new Guid("37e130ed-876d-4989-84c2-fe372442ac3b"))
            );

            // Output : intParam4
            // Inputs : IntParam4
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam4", new Guid("e6c06318-9cdd-4fab-a095-e44b4b2cb7c5"))
            );

            // Output : intParam5
            // Inputs : IntParam5
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam5", new Guid("534ed20e-bf63-4143-9b54-77674aeba4e6"))
            );

            // Output : floatParam0
            // Inputs : FloatParam0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam0", new Guid("390d0fca-a2b3-426d-b68b-ba8f510aa8e2"))
            );

            // Output : floatParam1
            // Inputs : FloatParam1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam1", new Guid("21ca547e-703e-4e13-acc5-ec4b2f3a36b7"))
            );

            // Output : floatParam2
            // Inputs : FloatParam2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam2", new Guid("0bf83c97-3ee1-4e42-a295-944e6ea62f01"))
            );

            // Output : floatParam3
            // Inputs : FloatParam3
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam3", new Guid("1d036235-6210-46ad-bcdd-9368a4bb1a9e"))
            );

            // Output : floatParam4
            // Inputs : FloatParam4
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam4", new Guid("4eea2ef0-1882-431a-b63d-d3821049df1c"))
            );

            // Output : floatParam5
            // Inputs : FloatParam5
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam5", new Guid("0b18b3b6-6225-4ad9-9c6c-1a5a86f45bb9"))
            );

            // Output : floatParam6
            // Inputs : FloatParam6
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam6", new Guid("1b487c00-39be-47ba-9de8-a263f5bb6ff0"))
            );

            // Output : floatParam7
            // Inputs : FloatParam7
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting0BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam7", new Guid("07897b84-5f0c-4ca0-b294-e21febb53590"))
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = customActionSetting0BinaryData;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private CustomActionSetting0BinaryConversionInfo(DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }
    }
}
