﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// The user data data model class.
    /// </summary>
    [Serializable]
    public class CustomActionSetting0 : CustomActionSettingData
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public CustomActionSetting0() :
            base()
        {
            this.Flag0 = 0x00000000;
            this.IntParam0 = 0;
            this.IntParam1 = 0;
            this.IntParam2 = 0;
            this.IntParam3 = 0;
            this.IntParam4 = 0;
            this.IntParam5 = 0;
            this.FloatParam0 = 0f;
            this.FloatParam1 = 0f;
            this.FloatParam2 = 0f;
            this.FloatParam3 = 0f;
            this.FloatParam4 = 0f;
            this.FloatParam5 = 0f;
            this.FloatParam6 = 0f;
            this.FloatParam7 = 0f;

            this.PostConstruct();
        }

        /// <summary>
        /// Get or set the flag value 0.
        /// </summary>
        [DataModelPropertyGuid("dfa5cb8e-3a0e-4f4b-bf03-0fce74d25b55")]
        public uint Flag0 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 0.
        /// </summary>
        [DataModelPropertyGuid("aaf925d1-402a-4ef1-adbb-24310e6629cc")]
        public int IntParam0 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 1.
        /// </summary>
        [DataModelPropertyGuid("b1db8c2d-83c6-40de-bfd7-3b277745352f")]
        public int IntParam1 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 2.
        /// </summary>
        [DataModelPropertyGuid("57d8fdb6-1c7b-4248-a72d-e6ad28c5ee05")]
        public int IntParam2 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 3.
        /// </summary>
        [DataModelPropertyGuid("37e130ed-876d-4989-84c2-fe372442ac3b")]
        public int IntParam3 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 4.
        /// </summary>
        [DataModelPropertyGuid("e6c06318-9cdd-4fab-a095-e44b4b2cb7c5")]
        public int IntParam4 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 5.
        /// </summary>
        [DataModelPropertyGuid("534ed20e-bf63-4143-9b54-77674aeba4e6")]
        public int IntParam5 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 0.
        /// </summary>
        [DataModelPropertyGuid("390d0fca-a2b3-426d-b68b-ba8f510aa8e2")]
        public float FloatParam0 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 1.
        /// </summary>
        [DataModelPropertyGuid("21ca547e-703e-4e13-acc5-ec4b2f3a36b7")]
        public float FloatParam1 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 2.
        /// </summary>
        [DataModelPropertyGuid("0bf83c97-3ee1-4e42-a295-944e6ea62f01")]
        public float FloatParam2 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 3.
        /// </summary>
        [DataModelPropertyGuid("1d036235-6210-46ad-bcdd-9368a4bb1a9e")]
        public float FloatParam3 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 4.
        /// </summary>
        [DataModelPropertyGuid("4eea2ef0-1882-431a-b63d-d3821049df1c")]
        public float FloatParam4 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 5.
        /// </summary>
        [DataModelPropertyGuid("0b18b3b6-6225-4ad9-9c6c-1a5a86f45bb9")]
        public float FloatParam5 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 6.
        /// </summary>
        [DataModelPropertyGuid("1b487c00-39be-47ba-9de8-a263f5bb6ff0")]
        public float FloatParam6 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 7.
        /// </summary>
        [DataModelPropertyGuid("07897b84-5f0c-4ca0-b294-e21febb53590")]
        public float FloatParam7 { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.CustomActionSetting0;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Flag0 = srcDataModel.Flag0;
            this.IntParam0 = srcDataModel.IntParam0;
            this.IntParam1 = srcDataModel.IntParam1;
            this.IntParam2 = srcDataModel.IntParam2;
            this.IntParam3 = srcDataModel.IntParam3;
            this.IntParam4 = srcDataModel.IntParam4;
            this.IntParam5 = srcDataModel.IntParam5;
            this.FloatParam0 = srcDataModel.FloatParam0;
            this.FloatParam1 = srcDataModel.FloatParam1;
            this.FloatParam2 = srcDataModel.FloatParam2;
            this.FloatParam3 = srcDataModel.FloatParam3;
            this.FloatParam4 = srcDataModel.FloatParam4;
            this.FloatParam5 = srcDataModel.FloatParam5;
            this.FloatParam6 = srcDataModel.FloatParam6;
            this.FloatParam7 = srcDataModel.FloatParam7;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Flag0", this.Flag0);
            this.WriteElement(context, "IntParam0", this.IntParam0);
            this.WriteElement(context, "IntParam1", this.IntParam1);
            this.WriteElement(context, "IntParam2", this.IntParam2);
            this.WriteElement(context, "IntParam3", this.IntParam3);
            this.WriteElement(context, "IntParam4", this.IntParam4);
            this.WriteElement(context, "IntParam5", this.IntParam5);
            this.WriteElement(context, "FloatParam0", this.FloatParam0);
            this.WriteElement(context, "FloatParam1", this.FloatParam1);
            this.WriteElement(context, "FloatParam2", this.FloatParam2);
            this.WriteElement(context, "FloatParam3", this.FloatParam3);
            this.WriteElement(context, "FloatParam4", this.FloatParam4);
            this.WriteElement(context, "FloatParam5", this.FloatParam5);
            this.WriteElement(context, "FloatParam6", this.FloatParam6);
            this.WriteElement(context, "FloatParam7", this.FloatParam7);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Flag0 = this.ReadElement(context, "Flag0", this.Flag0);
            this.IntParam0 = this.ReadElement(context, "IntParam0", this.IntParam0);
            this.IntParam1 = this.ReadElement(context, "IntParam1", this.IntParam1);
            this.IntParam2 = this.ReadElement(context, "IntParam2", this.IntParam2);
            this.IntParam3 = this.ReadElement(context, "IntParam3", this.IntParam3);
            this.IntParam4 = this.ReadElement(context, "IntParam4", this.IntParam4);
            this.IntParam5 = this.ReadElement(context, "IntParam5", this.IntParam5);
            this.FloatParam0 = this.ReadElement(context, "FloatParam0", this.FloatParam0);
            this.FloatParam1 = this.ReadElement(context, "FloatParam1", this.FloatParam1);
            this.FloatParam2 = this.ReadElement(context, "FloatParam2", this.FloatParam2);
            this.FloatParam3 = this.ReadElement(context, "FloatParam3", this.FloatParam3);
            this.FloatParam4 = this.ReadElement(context, "FloatParam4", this.FloatParam4);
            this.FloatParam5 = this.ReadElement(context, "FloatParam5", this.FloatParam5);
            this.FloatParam6 = this.ReadElement(context, "FloatParam6", this.FloatParam6);
            this.FloatParam7 = this.ReadElement(context, "FloatParam7", this.FloatParam7);

            return success;
        }
    }
}
