﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace CombinerNodeEditor.UserControl
{
    /// <summary>
    /// NodeViewer.xaml の相互作用ロジック
    /// </summary>
    public partial class NodeViewer : System.Windows.Controls.UserControl
    {
        public NodeViewer()
        {
            InitializeComponent();
            Invalidate();
        }

        public void Invalidate()
        {
            // 現在の DataContext で UI 作り直し
            this.RootControl.Children.Clear();
            NodeDesc desc = this.DataContext as NodeDesc;
            if (desc != null)
            {
                // 入出力
                var inoutGrid = new Grid();
                {
                    var strokeRect = new Rectangle();
                    strokeRect.Stroke = new SolidColorBrush(Colors.Black);
                    strokeRect.StrokeThickness = 1.0;
                    strokeRect.Fill = new SolidColorBrush(Colors.LightGray);
                    inoutGrid.Children.Add(strokeRect);

                    var basePanel = new Grid();
                    var c0 = new ColumnDefinition();
                    c0.Width = new GridLength(1, GridUnitType.Star);
                    var c1 = new ColumnDefinition();
                    c1.Width = new GridLength(1, GridUnitType.Star);
                    basePanel.ColumnDefinitions.Add(c0);
                    basePanel.ColumnDefinitions.Add(c1);
                    //basePanel.Background = new SolidColorBrush(Colors.LightGray);
                    var inputStackPanel = new StackPanel();
                    var outputStackPanel = new StackPanel();

                    // 入力
                    foreach (var input in desc.InputDescs)
                    {
                        var stack = new StackPanel();
                        stack.Orientation = Orientation.Horizontal;
                        stack.Margin = new Thickness(0, 2, 0, 2);
                        stack.Height = 14;
                        stack.HorizontalAlignment = HorizontalAlignment.Left;

                        var circle = new Ellipse();
                        circle.Width = 14;
                        circle.Fill = new SolidColorBrush(Colors.Gray);
                        circle.Margin = new Thickness(-7, 0, 0, 0);
                        circle.Stroke = new SolidColorBrush(Colors.Black);
                        circle.StrokeThickness = 1.0;
                        var text = new TextBlock();
                        text.Text = input.DisplayName;
                        text.FontSize = 10.5;
                        text.HorizontalAlignment = HorizontalAlignment.Left;
                        text.Margin = new Thickness(4, 0, 0, 0);

                        stack.Children.Add(circle);
                        stack.Children.Add(text);
                        inputStackPanel.Children.Add(stack);
                    }
                    inputStackPanel.Margin = new Thickness(0, 4, 8, 4);
                    inputStackPanel.SetValue(Grid.ColumnProperty, 0);

                    // 出力
                    foreach (var output in desc.OutputDescs)
                    {
                        var stack = new StackPanel();
                        stack.Orientation = Orientation.Horizontal;
                        stack.Margin = new Thickness(0, 2, 0, 2);
                        stack.Height = 14;
                        stack.HorizontalAlignment = HorizontalAlignment.Right;

                        var circle = new Ellipse();
                        circle.Width = 14;
                        circle.Fill = new SolidColorBrush(Colors.Gray);
                        circle.Margin = new Thickness(0, 0, -7, 0);
                        circle.Stroke = new SolidColorBrush(Colors.Black);
                        circle.StrokeThickness = 1.0;
                        var text = new TextBlock();
                        text.Text = output.DisplayName;
                        text.FontSize = 10.5;
                        text.HorizontalAlignment = HorizontalAlignment.Right;
                        text.Margin = new Thickness(0, 0, 4, 0);

                        stack.Children.Add(text);
                        stack.Children.Add(circle);
                        outputStackPanel.Children.Add(stack);
                    }
                    outputStackPanel.Margin = new Thickness(8, 4, 0, 4);
                    outputStackPanel.SetValue(Grid.ColumnProperty, 1);

                    basePanel.Children.Add(inputStackPanel);
                    basePanel.Children.Add(outputStackPanel);
                    inoutGrid.Children.Add(basePanel);
                }

                // ノード名
                var nodeNameGrid = new Grid();
                {
                    nodeNameGrid.Background = new SolidColorBrush(Colors.LightBlue);
                    var nodeNameTextBlock = new TextBlock();
                    nodeNameTextBlock.Text = desc.Block.DisplayName;
                    nodeNameTextBlock.Padding = new Thickness(8);
                    nodeNameTextBlock.FontSize = 12;
                    nodeNameTextBlock.Foreground = new SolidColorBrush(Colors.Black);

                    var nodeNameStroke = new Rectangle();
                    nodeNameStroke.Fill = new SolidColorBrush(Colors.Transparent);
                    nodeNameStroke.Stroke = new SolidColorBrush(Colors.Black);
                    nodeNameStroke.StrokeThickness = 1.0;
                    nodeNameGrid.Children.Add(nodeNameTextBlock);
                    nodeNameGrid.Children.Add(nodeNameStroke);
                }

                this.RootControl.Children.Add(nodeNameGrid);
                this.RootControl.Children.Add(inoutGrid);
                this.RootControl.Width = 225;

                // サイズを自動調整
                this.Width = Double.NaN;
                this.Height = Double.NaN;
            }
        }

        /// <summary>
        /// データコンテキストの変更イベントです。
        /// </summary>
        /// <param name="sender">イベントの発生元</param>
        /// <param name="e">イベント情報</param>
        private void NodeViewer_DataContextChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            this.Invalidate();
        }
    }
}
