﻿/// <tag name="Texture">
///  <func id="GetTextureColor0"/>
/// </tag>
/// <func id="GetTextureColor0" name="GetTextureColor0">
///  <in name="uv" type="vec2"/>
///  <return type="vec4"/>
///  <description>テクスチャ0のカラー</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439d-955A-47650F4842A5}" displayname="TexColor0" group="Texture">
///  <func id="GetTextureColor0"/>
///  <in displayname="uv" type="vec2" target="uv" semantic="TexCoord0"/>
///  <out displayname="Color" type="vec4" target="return"/>
///  <out displayname="RGB" type="vec3" target="return.xyz"/>
///  <out displayname="A" type="float" target="return.w"/>
///  <uniform name="nwAlbedoTexture0" type="file" extension=".ftxb" displayname="Albedo0"/>
///  <preview enabled="true" width="64" height="64"/>
/// </block>
vec4 GetTextureColor0( vec2 uv )
{
#if !defined(_TEX0_MIPMAP_LEVEL_LIMIT) || !defined(_USE_NN_VFX)
    vec4 color = texture2D( sysTextureSampler0, uv );
#else
    float lod = textureQueryLod( sysTextureSampler0, uv ).x;
    if ( lod > MIPMAPLEVEL_LIMIT )
    {
        lod = MIPMAPLEVEL_LIMIT;
    }
    vec4 color = textureLod( sysTextureSampler0, uv, lod );
#endif

#ifdef _TEX0_COLOR_INPUT_SQUARE
  color.rgb = color.rgb * color.rgb;
#endif
  return color;
}


/// <tag name="Texture">
///  <func id="GetTextureColor1"/>
/// </tag>
/// <func id="GetTextureColor1" name="GetTextureColor1">
///  <in name="uv" type="vec2"/>
///  <return type="vec4"/>
///  <description>テクスチャ1のカラー</description>
/// </func>
/// <block guid="{4E99B7CB-1A92-4e6d-88F2-075E488C8E73}" displayname="TexColor1" group="Texture">
///  <func id="GetTextureColor1"/>
///  <in displayname="uv" type="vec2" target="uv" semantic="TexCoord1"/>
///  <out displayname="Color" type="vec4" target="return"/>
///  <out displayname="RGB" type="vec3" target="return.xyz"/>
///  <out displayname="A" type="float" target="return.w"/>
///  <uniform name="nwAlbedoTexture1" type="file" extension=".ftxb" displayname="Albedo1"/>
///  <preview enabled="true" width="64" height="64"/>
/// </block>
vec4 GetTextureColor1( vec2 uv )
{
#if !defined(_TEX1_MIPMAP_LEVEL_LIMIT) || !defined(_USE_NN_VFX)
    vec4 color = texture2D( sysTextureSampler1, uv );
#else
    float lod = textureQueryLod( sysTextureSampler1, uv ).x;
    if ( lod > MIPMAPLEVEL_LIMIT )
    {
        lod = MIPMAPLEVEL_LIMIT;
    }
    vec4 color = textureLod( sysTextureSampler1, uv, lod );
#endif

#ifdef _TEX0_COLOR_INPUT_SQUARE
  color.rgb = color.rgb * color.rgb;
#endif
  return color;
}


/// <tag name="Texture">
///  <func id="GetTextureColor2"/>
/// </tag>
/// <func id="GetTextureColor2" name="GetTextureColor2">
///  <in name="uv" type="vec2"/>
///  <return type="vec4"/>
///  <description>テクスチャ2のカラー</description>
/// </func>
/// <block guid="{4E99B7CB-1A92-4e6d-88F2-085E488C8E73}" displayname="TexColor2" group="Texture">
///  <func id="GetTextureColor2"/>
///  <in displayname="uv" type="vec2" target="uv" semantic="TexCoord2"/>
///  <out displayname="Color" type="vec4" target="return"/>
///  <out displayname="RGB" type="vec3" target="return.xyz"/>
///  <out displayname="A" type="float" target="return.w"/>
///  <uniform name="nwAlbedoTexture2" type="file" extension=".ftxb" displayname="Albedo2"/>
///  <preview enabled="true" width="64" height="64"/>
/// </block>
vec4 GetTextureColor2( vec2 uv )
{
#if !defined(_TEX2_MIPMAP_LEVEL_LIMIT) || !defined(_USE_NN_VFX)
    vec4 color = texture2D( sysTextureSampler2, uv );
#else
    float lod = textureQueryLod( sysTextureSampler2, uv ).x;
    if ( lod > MIPMAPLEVEL_LIMIT )
    {
        lod = MIPMAPLEVEL_LIMIT;
    }
    vec4 color = textureLod( sysTextureSampler2, uv, lod );
#endif

#ifdef _TEX0_COLOR_INPUT_SQUARE
  color.rgb = color.rgb * color.rgb;
#endif
  return color;
}


/// <tag name="Texture">
///  <func id="GetProjctionTextureColor0"/>
/// </tag>
/// <func id="GetProjctionTextureColor0" name="GetProjctionTextureColor0">
///  <in name="proj" type="vec4"/>
///  <return type="vec4"/>
///  <description>投影テクスチャ0のカラー</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439d-955A-47650F4842A6}" displayname="TexProjColor0">
///  <func id="GetProjctionTextureColor0"/>
///  <in displayname="ProjPos4" type="vec4" target="proj"/>
///  <out displayname="Color" type="vec4" target="return"/>
///  <out displayname="RGB" type="vec3" target="return.xyz"/>
///  <out displayname="A" type="float" target="return.w"/>
/// </block>
vec4 GetProjctionTextureColor0( vec4 proj )
{
  return texture2DProj( sysTextureSampler0, proj );
}


/// <tag name="Texture">
///  <func id="GetProjctionTextureColor1"/>
/// </tag>
/// <func id="GetProjctionTextureColor1" name="GetProjctionTextureColor1">
///  <in name="proj" type="vec4"/>
///  <return type="vec4"/>
///  <description>投影テクスチャ1のカラー</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439d-955A-47650F4842A7}" displayname="TexProjColor1">
///  <func id="GetProjctionTextureColor1"/>
///  <in displayname="ProjPos4" type="vec4" target="proj"/>
///  <out displayname="Color" type="vec4" target="return"/>
///  <out displayname="RGB" type="vec3" target="return.xyz"/>
///  <out displayname="A" type="float" target="return.w"/>
/// </block>
vec4 GetProjctionTextureColor1( vec4 proj )
{
  return texture2DProj( sysTextureSampler1, proj );
}


/// <tag name="Texture">
///  <func id="GetProjctionTextureColor2"/>
/// </tag>
/// <func id="GetProjctionTextureColor2" name="GetProjctionTextureColor2">
///  <in name="proj" type="vec4"/>
///  <return type="vec4"/>
///  <description>投影テクスチャ2のカラー</description>
/// </func>
/// <block guid="{7C94EB0B-B19A-439d-955A-47650F4842A7}" displayname="TexProjColor2">
///  <func id="GetProjctionTextureColor2"/>
///  <in displayname="ProjPos4" type="vec4" target="proj"/>
///  <out displayname="Color" type="vec4" target="return"/>
///  <out displayname="RGB" type="vec3" target="return.xyz"/>
///  <out displayname="A" type="float" target="return.w"/>
/// </block>
vec4 GetProjctionTextureColor2( vec4 proj )
{
  return texture2DProj( sysTextureSampler2, proj );
}


/// <tag name="Texture">
///  <func id="GetFrameBufferColor"/>
/// </tag>
/// <func id="GetFrameBufferColor" name="GetFrameBufferColor">
///  <in name="proj" type="vec4"/>
///  <return type="vec4"/>
///  <description>フレームバッファカラー</description>
/// </func>
/// <block guid="{5389679F-CA5E-4e2a-8556-1CDF3EB5A659}" displayname="FrameBuffer">
///  <func id="GetFrameBufferColor"/>
///  <in displayname="ProjPos4" type="vec4" target="proj"/>
///  <out displayname="Color" type="vec4" target="return"/>
///  <out displayname="RGB" type="vec3" target="return.xyz"/>
///  <out displayname="A" type="float" target="return.w"/>
/// </block>
vec4 GetFrameBufferColor( vec4 proj )
{
  return texture2DProj( sysFrameBufferTexture, proj );
}


/// <tag name="Texture">
///  <func id="GetFrameBufferColorUv"/>
/// </tag>
/// <func id="GetFrameBufferColorUv" name="GetFrameBufferColorUv">
///  <in name="uv" type="vec2"/>
///  <return type="vec4"/>
///  <description>フレームバッファカラー（uvからサンプル）</description>
/// </func>
/// <block guid="{5389689F-CA5E-4e2a-9556-1CDF3EB6A659}" displayname="FrameBufferUV">
///  <func id="GetFrameBufferColorUv"/>
///  <in displayname="uv" type="vec2" target="uv"/>
///  <out displayname="Color" type="vec4" target="return"/>
///  <out displayname="RGB" type="vec3" target="return.xyz"/>
///  <out displayname="A" type="float" target="return.w"/>
/// </block>
vec4 GetFrameBufferColorUv( vec2 uv )
{
#if defined( _TEXTURE_ORIGIN_LOWER_LEFT )
  return texture2D( sysFrameBufferTexture, vec2(uv.x, -uv.y) );
#else
  return texture2D( sysFrameBufferTexture, uv );
#endif
}


/// <tag name="Texture">
///  <func id="GetDepthBufferColor"/>
/// </tag>
/// <func id="GetDepthBufferColor" name="GetDepthBufferColor">
///  <in name="proj" type="vec4"/>
///  <return type="vec4"/>
///  <description>デプスバッファの値</description>
/// </func>
/// <block guid="{5389679F-CA5E-4e2a-8556-1CDF3EB5A660}" displayname="DepthBuffer">
///  <func id="GetDepthBufferColor"/>
///  <in displayname="ProjPos4" type="vec4" target="proj"/>
///  <out displayname="Color" type="vec4" target="return"/>
///  <out displayname="RGB" type="vec3" target="return.xyz"/>
///  <out displayname="A" type="float" target="return.w"/>
/// </block>
vec4 GetDepthBufferColor( vec4 proj )
{
  return texture2DProj( sysDepthBufferTexture, proj );
}


/// <tag name="Texture">
///  <func id="GetDepthBufferColorUv"/>
/// </tag>
/// <func id="GetDepthBufferColorUv" name="GetDepthBufferColorUv">
///  <in name="uv" type="vec2"/>
///  <return type="vec4"/>
///  <description>デプスバッファの値（uvからサンプル）</description>
/// </func>
/// <block guid="{5389679F-CA5E-4e2a-8556-1CDF3EB5A761}" displayname="DepthBufferUV">
///  <func id="GetDepthBufferColorUv"/>
///  <in displayname="uv" type="vec2" target="uv"/>
///  <out displayname="Color" type="vec4" target="return"/>
///  <out displayname="RGB" type="vec3" target="return.xyz"/>
///  <out displayname="A" type="float" target="return.w"/>
/// </block>
vec4 GetDepthBufferColorUv( vec2 uv )
{
#if defined( _TEXTURE_ORIGIN_LOWER_LEFT )
  return texture2D( sysDepthBufferTexture, vec2(uv.x, -uv.y) );
#else
  return texture2D( sysDepthBufferTexture, uv );
#endif

}


/// <tag name="Texture">
///   <func id="GetLinearGradH" />
/// </tag>
/// <func id="GetLinearGradH" name="GetLinearGradH">
///   <return type="vec3" />
///   <in name="uv" type="vec2" />
///   <description>線形グラデーション（横方向）をプロシージャルに取得。ラップ設定は Clamp</description>
/// </func>
/// <block guid="{6834962C-A5CE-4F86-8AD4-BA00E446B5E3}" displayname="LinearGradH">
///   <func id="GetLinearGradH"/>
///   <in displayname="uv" type="vec2" target="uv" />
///   <out displayname="default(float)" type="float" target="return.x" />
///   <out displayname="default(rgb)" type="vec3" target="return.xxx" />
///   <out displayname="reverse(float)" type="float" target="return.y" />
///   <out displayname="reverse(rgb)" type="vec3" target="return.yyy" />
/// </block>
vec3 GetLinearGradH(vec2 uv)
{
  return clamp(vec3( uv.x, (1.0 - uv.x), 0.0 ), 0.0, 1.0);
}


/// <tag name="Texture">
///   <func id="GetLinearGradV" />
/// </tag>
/// <func id="GetLinearGradV" name="GetLinearGradV">
///   <return type="vec3" />
///   <in name="uv" type="vec2" />
///   <description>線形グラデーション（縦方向）をプロシージャルに取得。ラップ設定は Clamp</description>
/// </func>
/// <block guid="{A561A0F4-F4F8-45E0-A243-DAF9FBB4C969}" displayname="LinearGradV">
///   <func id="GetLinearGradV"/>
///   <in displayname="uv" type="vec2" target="uv" />
///   <out displayname="default(float)" type="float" target="return.x" />
///   <out displayname="default(rgb)" type="vec3" target="return.xxx" />
///   <out displayname="reverse(float)" type="float" target="return.y" />
///   <out displayname="reverse(rgb)" type="vec3" target="return.yyy" />
/// </block>
vec3 GetLinearGradV(vec2 uv)
{
  return clamp(vec3( uv.y, (1.0 - uv.y), 0.0 ), 0.0, 1.0);
}


/// <tag name="Texture">
///   <func id="GetRadialGradient" />
/// </tag>
/// <func id="GetRadialGradient" name="GetRadialGradient">
///   <return type="vec3" />
///   <in name="uv" type="vec2" />
///   <description>円形グラデーションをプロシージャルに取得。ラップ設定は Clamp</description>
/// </func>
/// <block guid="{3A63972E-E930-4C9C-809A-370BF9F8703C}" displayname="RadialGradient">
///   <func id="GetRadialGradient"/>
///   <in displayname="uv" type="vec2" target="uv" />
///   <out displayname="default(float)" type="float" target="return.x" />
///   <out displayname="default(rgb)" type="vec3" target="return.xxx" />
///   <out displayname="reverse(float)" type="float" target="return.y" />
///   <out displayname="reverse(rgb)" type="vec3" target="return.yyy" />
/// </block>
vec3 GetRadialGradient(vec2 uv)
{
  vec2 pos = uv * 2 - vec2( 1, 1 );
  float v = 1.0 - sqrt(pos.x * pos.x + pos.y * pos.y);
  return clamp(vec3( v, (1.0 - v), 0.0 ), 0.0, 1.0);
}
