﻿/// <tag name="Input">
///  <func id="GetColor0"/>
/// </tag>
/// <func id="GetColor0" name="GetColor0">
///  <return type="vec4"/>
///  <description>頂点シェーダの出力 Color0</description>
/// </func>
/// <block guid="{2F67BE3F-1FFB-40d7-BB01-256B1CF17868}" displayname="Color0" group="Uniform">
///  <func id="GetColor0"/>
///  <out displayname="Color" type="vec4" target="return"/>
///  <out displayname="RGB" type="vec3" target="return.xyz"/>
///  <out displayname="A" type="float" target="return.w"/>
///  <preview enabled="true" width="64" height="64"/>
///  <uniform name="m_VectorParameter0" type="vec4" displayname="Color0"/>
/// </block>
vec4 GetColor0()
{
  return v_outColor0;
}


/// <tag name="Input">
///  <func id="GetColor1"/>
/// </tag>
/// <func id="GetColor1" name="GetColor1">
///  <return type="vec4"/>
///  <description>頂点シェーダの出力 Color1</description>
/// </func>
/// <block guid="{B5651A48-460A-4ae6-B529-2C7AA3ED98AB}" displayname="Color1" group="Uniform">
///  <func id="GetColor1"/>
///  <out displayname="Color" type="vec4" target="return"/>
///  <out displayname="RGB" type="vec3" target="return.xyz"/>
///  <out displayname="A" type="float" target="return.w"/>
///  <preview enabled="true" width="64" height="64"/>
///  <uniform name="m_VectorParameter1" type="vec4" displayname="Color1"/>
/// </block>
vec4 GetColor1()
{
  return v_outColor1;
}


/// <tag name="Input">
///  <func id="GetLifeRatio"/>
/// </tag>
/// <func id="GetLifeRatio" name="GetLifeRatio">
///  <return type="float"/>
///  <description>パーティクルの寿命を 0.0 ～ 1.0 の割合で取得</description>
/// </func>
/// <block guid="{ED2F88FC-08A6-46DB-9021-5AAE397F7D7D}" displayname="LifeRatio">
///  <func id="GetLifeRatio"/>
///  <out displayname="Ratio[0.0 - 1.0]" type="float" target="return"/>
///  <uniform name="m_ShaderParameter[ 0 ]" type="float" displayname="LifeRatio"/>
/// </block>
float GetLifeRatio()
{
  return sysLifeRatio;
}


/// <tag name="Input">
///  <func id="GetInputPrimitiveColor"/>
/// </tag>
/// <func id="GetInputPrimitiveColor" name="GetInputPrimitiveColor">
///  <return type="vec4"/>
///  <description>プリミティブカラー</description>
/// </func>
/// <block guid="{54D711FF-14D5-4c59-9C96-05F1344A28D7}" displayname="PrimitiveColor" group="Uniform">
///  <func id="GetInputPrimitiveColor"/>
///  <out displayname="Color" type="vec4" target="return"/>
///  <out displayname="RGB" type="vec3" target="return.xyz"/>
///  <out displayname="A" type="float" target="return.w"/>
///  <uniform name="m_VectorParameter2" type="vec4" displayname="PrimitiveColor"/>
/// </block>
vec4 GetInputPrimitiveColor()
{
  return v_outPrimitiveColor;
}


/// <tag name="Input">
///  <func id="GetWorldPosition"/>
/// </tag>
/// <func id="GetWorldPosition" name="GetWorldPosition">
///  <return type="vec4"/>
///  <description>ワールド座標</description>
/// </func>
/// <block guid="{48933679-4DFC-4e96-85E5-150A93754A9F}" displayname="WorldPos">
///  <func id="GetWorldPosition"/>
///  <out displayname="vec4" type="vec4" target="return"/>
///  <out displayname="vec3" type="vec3" target="return.xyz"/>
/// </block>
vec4 GetWorldPosition()
{
  return vec4( sysWorldPositionVary, 1 );
}


/// <tag name="Input">
///  <func id="GetNormal34"/>
/// </tag>
/// <func id="GetNormal34" name="GetNormal34">
///  <return type="vec4"/>
///  <description>法線ベクトル</description>
/// </func>
/// <block guid="{EFB50C6F-B3F8-4f1b-A008-8B28DD5DCD62}" displayname="Normal">
///  <func id="GetNormal34"/>
///  <out displayname="vec4" type="vec4" target="return"/>
///  <out displayname="vec3" type="vec3" target="return.xyz"/>
/// </block>
vec4 GetNormal34()
{
  return vec4( normalize( v_outWorldNormal ), 1 );
}


/// <tag name="Input">
///  <func id="GetNormal3"/>
/// </tag>
/// <func id="GetNormal3" name="GetNormal3">
///  <return type="vec3"/>
///  <description>法線ベクトル</description>
/// </func>
/// <block guid="{EFB50C6F-B3F8-4f1b-A008-8B28DD5DCC61}" displayname="Normal3">
///  <func id="GetNormal3"/>
///  <out displayname="vec3" type="vec3" target="return"/>
/// </block>
vec3 GetNormal3()
{
  return normalize( v_outWorldNormal );
}


/// <tag name="Input">
///  <func id="GetNormal"/>
/// </tag>
/// <func id="GetNormal" name="GetNormal">
///  <return type="vec4"/>
///  <description>法線ベクトル</description>
/// </func>
/// <block guid="{EFB50C6F-B3F8-4f1c-A008-8B28DD5DCC61}" displayname="Normal4">
///  <func id="GetNormal"/>
///  <out displayname="vec4" type="vec4" target="return"/>
/// </block>
vec4 GetNormal()
{
  return vec4( normalize( v_outWorldNormal ), 1 );
}


/// <tag name="Input">
///  <func id="GetViewPos"/>
/// </tag>
/// <func id="GetViewPos" name="GetViewPos">
///  <return type="vec3"/>
///  <description>視点の位置</description>
/// </func>
/// <block guid="{80C831FA-2BEF-53ce-91C8-CA359C792C39}" displayname="EyePos">
///  <func id="GetViewPos"/>
///  <out displayname="vec3" type="vec3" target="return"/>
/// </block>
vec3 GetViewPos()
{
  return eyePos.xyz;
}


/// <tag name="Input">
///  <func id="GetViewVec"/>
/// </tag>
/// <func id="GetViewVec" name="GetViewVec">
///  <return type="vec3"/>
///  <description>視線方向ベクトル</description>
/// </func>
/// <block guid="{80C831FA-2BEE-43ce-90C8-CA359C792C39}" displayname="LookDir">
///  <func id="GetViewVec"/>
///  <out displayname="vec3" type="vec3" target="return"/>
/// </block>
vec3 GetViewVec()
{
  return normalize( eyeVec.xyz );
}


/// <tag name="Input">
///  <func id="GetViewVecPx"/>
/// </tag>
/// <func id="GetViewVecPx" name="GetViewVecPx">
///  <return type="vec3"/>
///  <description>視線方向ベクトル（ピクセル位置ベース）</description>
/// </func>
/// <block guid="{80C831FA-2BEE-43ce-90C8-CA369C892C40}" displayname="LookDir(Pixel)">
///  <func id="GetViewVecPx"/>
///  <out displayname="vec3" type="vec3" target="return"/>
/// </block>
vec3 GetViewVecPx()
{
  return normalize( ( sysWorldPositionVary.xyz - eyePos.xyz ) );
}


/// <tag name="Input">
///  <func id="GetViewPosition"/>
/// </tag>
/// <func id="GetViewPosition" name="GetViewPosition">
///  <return type="vec4"/>
///  <description>ワールド座標（ビュー座標系）</description>
/// </func>
/// <block guid="{48933680-4DFC-4e96-85E5-150A93754A9F}" displayname="ViewPos">
///  <func id="GetViewPosition"/>
///  <out displayname="vec4" type="vec4" target="return"/>
///  <out displayname="vec3" type="vec3" target="return.xyz"/>
/// </block>
vec4 GetViewPosition()
{
  return vec4( sysWorldPositionVary, 1 ) * sysViewMatrix;
}


/// <tag name="Input">
///  <func id="GetViewNormal"/>
/// </tag>
/// <func id="GetViewNormal" name="GetViewNormal">
///  <return type="vec4"/>
///  <description>法線ベクトル（ビュー座標系）</description>
/// </func>
/// <block guid="{48933681-4DFC-4e96-85E5-150A93754A9F}" displayname="ViewNormal">
///  <func id="GetViewNormal"/>
///  <out displayname="vec4" type="vec4" target="return"/>
///  <out displayname="vec3" type="vec3" target="return.xyz"/>
/// </block>
vec4 GetViewNormal()
{
  return normalize( sysViewMatrix *  vec4( sysWorldNormalVary, 1 ) );
}


/// <tag name="Input">
///   <func id="GetParticleRandom" />
/// </tag>
/// <func id="GetParticleRandom" name="GetParticleRandom">
///   <return type="vec4" />
///   <description>粒ごとに持つランダム値です。</description>
/// </func>
/// <block guid="{7FE3F1F9-F87E-47F0-993D-60E2DCC98DB9}" displayname="ParticleRandom">
///   <func id="GetParticleRandom"/>
///   <out displayname="xyzw" type="vec4" target="return" />
///   <out displayname="x" type="float" target="return.x" />
///   <out displayname="y" type="float" target="return.y" />
///   <out displayname="z" type="float" target="return.z" />
///   <out displayname="w" type="float" target="return.w" />
/// </block>
vec4 GetParticleRandom()
{
  return sysParticleRandom;
}


/// <tag name="Input">
///  <func id="GetAnimation0_X"/>
/// </tag>
/// <func id="GetAnimation0_X" name="GetAnimation0_X">
///  <return type="float"/>
///  <description>係数アニメ0の X 要素</description>
/// </func>
/// <block guid="{FEFD7EAA-376A-41C2-9B15-CB75A089E169}" displayname="Animation0_X">
///  <func id="GetAnimation0_X"/>
///  <out displayname="float" type="float" target="return"/>
/// </block>
float GetAnimation0_X()
{
  return sysShaderAnim;
}


/// <tag name="Input">
///  <func id="GetAnimation0_Y"/>
/// </tag>
/// <func id="GetAnimation0_Y" name="GetAnimation0_Y">
///  <return type="float"/>
///  <description>係数アニメ0の Y 要素</description>
/// </func>
/// <block guid="{E6100AEE-3FB6-4C3C-ABE4-281A7805CE22}" displayname="Animation0_Y">
///  <func id="GetAnimation0_Y"/>
///  <out displayname="float" type="float" target="return"/>
/// </block>
float GetAnimation0_Y()
{
  return sysShaderAnimY;
}


/// <tag name="Input">
///  <func id="GetAnimation0_Z"/>
/// </tag>
/// <func id="GetAnimation0_Z" name="GetAnimation0_Z">
///  <return type="float"/>
///  <description>係数アニメ0の Z 要素</description>
/// </func>
/// <block guid="{4C863EE1-A34B-448A-B7EC-42C13F216D91}" displayname="Animation0_Z">
///  <func id="GetAnimation0_Z"/>
///  <out displayname="float" type="float" target="return"/>
/// </block>
float GetAnimation0_Z()
{
  return sysShaderAnimZ;
}


/// <tag name="Input">
///  <func id="GetAnimation0_XYZ"/>
/// </tag>
/// <func id="GetAnimation0_XYZ" name="GetAnimation0_XYZ">
///  <return type="vec3"/>
///  <description>係数アニメ0（XYZ）</description>
/// </func>
/// <block guid="{1ABAF64D-9402-43D5-9F34-498E39747E9E}" displayname="Animation0_XYZ">
///  <func id="GetAnimation0_XYZ"/>
///  <out displayname="xyz" type="vec3" target="return"/>
/// </block>
vec3 GetAnimation0_XYZ()
{
    return vec3( sysShaderAnim, sysShaderAnimY, sysShaderAnimZ );
}


/// <tag name="Input">
///  <func id="GetPixelDepthValue"/>
/// </tag>
/// <func id="GetPixelDepthValue" name="GetPixelDepthValue">
///  <return type="float"/>
///  <description>今描画しようとしているピクセルのデプスを取得</description>
/// </func>
/// <block guid="{E34AF4F7-71A1-4926-AA3A-BEE9B41874DC}" displayname="DepthValue">
///  <func id="GetPixelDepthValue"/>
///  <out displayname="float" type="float" target="return"/>
/// </block>
float GetPixelDepthValue()
{
    return GetDepthValue( sysFragCoordVary );
}

/// <tag name="Input">
///  <func id="GetPixelDepthTextureValue"/>
/// </tag>
/// <func id="GetPixelDepthTextureValue" name="GetPixelDepthTextureValue">
///  <return type="float"/>
///  <description>デプステクスチャからデプス値を取得する</description>
/// </func>
/// <block guid="{50825D02-A23B-4807-A885-61BB1D128B7A}" displayname="DepthTextureValue">
///  <func id="GetPixelDepthTextureValue"/>
///  <out displayname="float" type="float" target="return"/>
/// </block>
float GetPixelDepthTextureValue()
{
    return GetDepthValueFromTexture( sysFragCoordVary );
}


/// <tag name="Input">
///  <func id="GetPixelDepthSubValue"/>
/// </tag>
/// <func id="GetPixelDepthSubValue" name="GetPixelDepthSubValue">
///  <return type="float"/>
///  <description>デプス差分を取得 ( GetPixelDepthTextureValue() - GetPixelDepthValue() )</description>
/// </func>
/// <block guid="{422DB91D-93EE-4F6E-9444-2311E87D4D1E}" displayname="DepthSubValue">
///  <func id="GetPixelDepthSubValue"/>
///  <out displayname="float" type="float" target="return"/>
/// </block>
float GetPixelDepthSubValue()
{
    return GetDepthValueFromTexture( sysFragCoordVary ) - GetDepthValue( sysFragCoordVary );
}

/// <tag name="Input">
///   <func id="GetEmitterDistance" />
/// </tag>
/// <func id="GetEmitterDistance" name="GetEmitterDistance">
///   <return type="float" />
///   <description>エミッタ位置からの距離</description>
/// </func>
/// <block guid="{EB6B29B7-DE74-4C8A-998E-4820678304CA}" displayname="EmitterDistance">
///   <func id="GetEmitterDistance"/>
///   <out displayname="distance" type="float" target="return" />
/// </block>
float GetEmitterDistance()
{
  vec3 emitterPos = vec3(sysEmitterRTMatrix[0].w, sysEmitterRTMatrix[1].w, sysEmitterRTMatrix[2].w);
  float dist = length(emitterPos.xyz - sysWorldPositionVary.xyz);
  return dist;
}

/// <tag name="Input">
///   <func id="GetEmitterPosition" />
/// </tag>
/// <func id="GetEmitterPosition" name="GetEmitterPosition">
///   <return type="vec3" />
///   <description>エミッタの位置を取得します</description>
/// </func>
/// <block guid="{C56D6180-4507-4B2B-BB8F-F1B03B91F365}" displayname="EmitterPosition">
///   <func id="GetEmitterPosition"/>
///   <out displayname="pos" type="vec3" target="return" />
/// </block>
vec3 GetEmitterPosition()
{
  vec3 emitterPos = vec3(sysEmitterRTMatrix[0].w, sysEmitterRTMatrix[1].w, sysEmitterRTMatrix[2].w);
  return emitterPos.xyz;
}

/// <tag name="Input">
///   <func id="GetDepthRawValue" />
/// </tag>
/// <func id="GetDepthRawValue" name="GetDepthRawValue">
///   <return type="float" />
///   <description>深度値を直接取得します</description>
/// </func>
/// <block guid="{AD1770A9-F521-4A47-9EA0-E9F0BB7E84EA}" displayname="DepthRawValue">
///   <func id="GetDepthRawValue"/>
///   <out displayname="value" type="float" target="return" />
/// </block>
float GetDepthRawValue()
{
  return texture2DProj( sysDepthBufferTexture, sysFragCoordVary ).r;
}
