﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Workflow.Core
{
    /// <summary>
    /// A WorkflowElement has a name and a unique identifier.
    /// </summary>
    public abstract class WorkflowElement : IUniquelyIdentifiable
    {
        protected WorkflowElement()
        {
            Identifier = Guid.NewGuid();
        }

        public Guid Identifier { get; private set; }

        private string name;
        public string Name
        {
            get { return name; }
            set
            {
                if (name == value)
                    return;

                var oldName = name;
                name = value;

                OnNameChanged(new NameChangedEventArgs(oldName, name));
            }
        }

        protected virtual void OnNameChanged(NameChangedEventArgs e)
        {
            var handler = NameChanged;
            if (handler != null)
                handler(this, e);
        }

        public event EventHandler<NameChangedEventArgs> NameChanged;
    }
}
