﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Workflow.Core
{
    public class InputPlugException<T> : Exception
    {
        public InputPlug<T> InputPlug { get; private set; }

        public InputPlugException(InputPlug<T> inputPlug, string message)
            : base(message)
        {
            if (inputPlug == null)
                throw new ArgumentNullException("inputPlug");
            if (message == null)
                throw new ArgumentNullException("message");

            InputPlug = inputPlug;
        }
    }

    public class OutputPlugException<T> : Exception
    {
        public OutputPlug<T> OutputPlug { get; private set; }

        public OutputPlugException(OutputPlug<T> outputPlug, string message)
            : base(message)
        {
            if (outputPlug == null)
                throw new ArgumentNullException("outputPlug");
            if (message == null)
                throw new ArgumentNullException("message");

            OutputPlug = outputPlug;
        }
    }
}
