﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace Workflow.Core
{
    public static class ControlNaming
    {
        private static readonly Dictionary<Type, byte[]> names = new Dictionary<Type, byte[]>();
        private const int LettersCount = 3;

        public static string GetNextName<T>()
        {
            byte[] letters;

            if (names.TryGetValue(typeof(T), out letters) == false)
            {
                letters = new byte[3];
                names.Add(typeof(T), letters);
            }

            var sb = new StringBuilder();

            sb.Append(typeof(T).Name);
            sb.Append("_");
            for (var i = LettersCount - 1; i >= 0; i--)
                sb.Append((char)(letters[i] + 'A'));

            var name = sb.ToString();

            IncrementName(letters, 0);

            return name;
        }

        private static void IncrementName(byte[] array, int index)
        {
            if (index > array.Length)
                throw new Exception(Messages.EXCEPTION_MAXIMUM_NAME_CAPACITY_REACHED);

            array[index]++;
            if (array[index] >= 26)
            {
                array[index] = 0;
                IncrementName(array, index + 1);
            }
        }
    }
}
