﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Workflow.Core;

namespace UnitTests
{
    [TestClass]
    public class WorkflowCoreWorkflowItem
    {
        [TestMethod]
        public void IsOrphanTest1()
        {
            var item1 = new DummyWorkflowItem("A");
            if (item1.IsOrphan == false)
                throw new Exception();
        }

        [TestMethod]
        public void IsOrphanTest2()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);

            if (item1.IsOrphan)
                throw new Exception();
            if (item2.IsOrphan)
                throw new Exception();
        }

        [TestMethod]
        public void IsOrphanTest3()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");

            ConnectionManager.Connect(item2.OutputPlugs[0], item1.InputPlugs[0]);

            if (item1.IsOrphan)
                throw new Exception();
            if (item2.IsOrphan)
                throw new Exception();
        }

        [TestMethod]
        public void IsOrphanTest4()
        {
            var item1 = new WorkflowItem<object>();

            if (item1.IsOrphan == false)
                throw new Exception();
        }

        [TestMethod]
        public void IsFullyConnectedTest1()
        {
            var item1 = new DummyWorkflowItem("A");

            if (item1.IsFullyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsFullyConnectedTest2()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);

            if (item1.IsFullyConnected)
                throw new Exception();
            if (item2.IsFullyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsFullyConnectedTest3()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[1]);

            if (item1.IsFullyConnected)
                throw new Exception();
            if (item2.IsFullyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsFullyConnectedTest4()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[1], item2.InputPlugs[1]);

            if (item1.IsFullyConnected)
                throw new Exception();
            if (item2.IsFullyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsFullyConnectedTest5()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");
            var item3 = new DummyWorkflowItem("C");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[1], item2.InputPlugs[1]);

            ConnectionManager.Connect(item2.OutputPlugs[0], item3.InputPlugs[0]);

            if (item1.IsFullyConnected)
                throw new Exception();
            if (item2.IsFullyConnected)
                throw new Exception();
            if (item3.IsFullyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsFullyConnectedTest6()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");
            var item3 = new DummyWorkflowItem("C");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[1], item2.InputPlugs[1]);

            ConnectionManager.Connect(item2.OutputPlugs[0], item3.InputPlugs[0]);
            ConnectionManager.Connect(item2.OutputPlugs[1], item3.InputPlugs[1]);

            if (item1.IsFullyConnected)
                throw new Exception();
            if (item2.IsFullyConnected == false)
                throw new Exception();
            if (item3.IsFullyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsFullyConnectedTest7()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");
            var item3 = new DummyWorkflowItem("C");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[1], item2.InputPlugs[1]);

            ConnectionManager.Connect(item2.OutputPlugs[0], item3.InputPlugs[0]);
            ConnectionManager.Connect(item2.OutputPlugs[1], item3.InputPlugs[1]);

            if (item1.IsFullyConnected)
                throw new Exception();
            if (item2.IsFullyConnected == false)
                throw new Exception();
            if (item3.IsFullyConnected)
                throw new Exception();

            ConnectionManager.Disconnect(item2.OutputPlugs[1]);

            if (item1.IsFullyConnected)
                throw new Exception();
            if (item2.IsFullyConnected)
                throw new Exception();
            if (item3.IsFullyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsFullyConnectedTest8()
        {
            var item1 = new WorkflowItem<object>();

            if (item1.IsFullyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsProperlyConnectedTest1()
        {
            var item1 = new DummyWorkflowItem("A");

            if (item1.IsProperlyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsProperlyConnectedTest2()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);

            if (item1.IsProperlyConnected)
                throw new Exception();
            if (item2.IsProperlyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsProperlyConnectedTest3()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[1]);

            if (item1.IsProperlyConnected)
                throw new Exception();
            if (item2.IsProperlyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsProperlyConnectedTest4()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[1], item2.InputPlugs[1]);

            if (item1.IsProperlyConnected)
                throw new Exception();
            if (item2.IsProperlyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsProperlyConnectedTest5()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");
            var item3 = new DummyWorkflowItem("C");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[1], item2.InputPlugs[1]);

            ConnectionManager.Connect(item2.OutputPlugs[0], item3.InputPlugs[0]);

            if (item1.IsProperlyConnected)
                throw new Exception();
            if (item2.IsProperlyConnected == false)
                throw new Exception();
            if (item3.IsProperlyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsProperlyConnectedTest6()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");
            var item3 = new DummyWorkflowItem("C");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[1], item2.InputPlugs[1]);

            ConnectionManager.Connect(item2.OutputPlugs[0], item3.InputPlugs[0]);
            ConnectionManager.Connect(item2.OutputPlugs[1], item3.InputPlugs[1]);

            if (item1.IsProperlyConnected)
                throw new Exception();
            if (item2.IsProperlyConnected == false)
                throw new Exception();
            if (item3.IsProperlyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsProperlyConnectedTest7()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");
            var item3 = new DummyWorkflowItem("C");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[1], item2.InputPlugs[1]);

            ConnectionManager.Connect(item2.OutputPlugs[0], item3.InputPlugs[0]);
            ConnectionManager.Connect(item2.OutputPlugs[1], item3.InputPlugs[1]);

            if (item1.IsProperlyConnected)
                throw new Exception();
            if (item2.IsProperlyConnected == false)
                throw new Exception();
            if (item3.IsProperlyConnected)
                throw new Exception();

            ConnectionManager.Disconnect(item2.OutputPlugs[1]);

            if (item1.IsProperlyConnected)
                throw new Exception();
            if (item2.IsProperlyConnected == false)
                throw new Exception();
            if (item3.IsProperlyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsProperlyConnectedTest8()
        {
            var item1 = new WorkflowItem<object>();

            if (item1.IsProperlyConnected)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphFullyConnectedTest1()
        {
            var item1 = new WorkflowItem<object>();

            if (WorkflowItem<object>.IsGraphFullyConnected(new[] { item1 }))
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphFullyConnectedTest2()
        {
            var item1 = new ProducerWorkflowItem("A");

            if (WorkflowItem<object>.IsGraphFullyConnected(new[] { item1 }))
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphFullyConnectedTest3()
        {
            var item1 = new ConsumerWorkflowItem("A");

            if (WorkflowItem<object>.IsGraphFullyConnected(new[] { item1 }))
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphFullyConnectedTest4()
        {
            var item1 = new ProducerWorkflowItem("A");
            var item2 = new ConsumerWorkflowItem("B");

            if (WorkflowItem<object>.IsGraphFullyConnected(new WorkflowItem<object>[] { item1, item2 }))
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphFullyConnectedTest5()
        {
            var item1 = new ProducerWorkflowItem("A");
            var item2 = new ConsumerWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[1]);

            if (WorkflowItem<object>.IsGraphFullyConnected(new WorkflowItem<object>[] { item1, item2 }))
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphFullyConnectedTest6()
        {
            var item1 = new ProducerWorkflowItem("A");
            var item2 = new ConsumerWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[1]);

            if (WorkflowItem<object>.IsGraphFullyConnected(new WorkflowItem<object>[] { item1, item2 }))
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphFullyConnectedTest7()
        {
            var item1 = new ProducerWorkflowItem("A");
            var item2 = new ConsumerWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[1]);
            ConnectionManager.Connect(item1.OutputPlugs[1], item2.InputPlugs[0]);

            if (WorkflowItem<object>.IsGraphFullyConnected(new WorkflowItem<object>[] { item1, item2 }) == false)
                throw new Exception();
        }

        //---------------------------------------------------------

        [TestMethod]
        public void IsGraphProperlyConnectedTest1()
        {
            var item1 = new WorkflowItem<object>();

            if (WorkflowItem<object>.IsGraphProperlyConnected(new[] { item1 }))
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphProperlyConnectedTest2()
        {
            var item1 = new ProducerWorkflowItem("A");

            if (WorkflowItem<object>.IsGraphProperlyConnected(new[] { item1 }))
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphProperlyConnectedTest3()
        {
            var item1 = new ConsumerWorkflowItem("A");

            if (WorkflowItem<object>.IsGraphProperlyConnected(new[] { item1 }))
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphProperlyConnectedTest4()
        {
            var item1 = new ProducerWorkflowItem("A");
            var item2 = new ConsumerWorkflowItem("B");

            if (WorkflowItem<object>.IsGraphProperlyConnected(new WorkflowItem<object>[] { item1, item2 }))
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphProperlyConnectedTest5()
        {
            var item1 = new ProducerWorkflowItem("A");
            var item2 = new ConsumerWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[1]);

            if (WorkflowItem<object>.IsGraphProperlyConnected(new WorkflowItem<object>[] { item1, item2 }))
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphProperlyConnectedTest6()
        {
            var item1 = new ProducerWorkflowItem("A");
            var item2 = new ConsumerWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[1]);

            if (WorkflowItem<object>.IsGraphProperlyConnected(new WorkflowItem<object>[] { item1, item2 }) == false)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphProperlyConnectedTest7()
        {
            var item1 = new ProducerWorkflowItem("A");
            var item2 = new ConsumerWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[1]);
            ConnectionManager.Connect(item1.OutputPlugs[1], item2.InputPlugs[0]);

            if (WorkflowItem<object>.IsGraphProperlyConnected(new WorkflowItem<object>[] { item1, item2 }) == false)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphProperlyConnectedTest8()
        {
            var item1 = new ProducerWorkflowItem("A");
            var item2 = new ProducerWorkflowItem("B");
            var item3 = new ConsumerWorkflowItem("C");

            ConnectionManager.Connect(item1.OutputPlugs[0], item3.InputPlugs[0]);
            ConnectionManager.Connect(item2.OutputPlugs[1], item3.InputPlugs[1]);

            if (WorkflowItem<object>.IsGraphProperlyConnected(new WorkflowItem<object>[] { item1, item2, item3 }) == false)
                throw new Exception();
        }

        //---------------------------------------------------------

        [TestMethod]
        public void IsGraphInputTest1()
        {
            var item1 = new WorkflowItem<object>();

            if (item1.IsGraphInput)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphInputTest2()
        {
            var item1 = new DummyWorkflowItem("A");

            if (item1.IsGraphInput)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphInputTest3()
        {
            var item1 = new ProducerWorkflowItem("A");

            if (item1.IsGraphInput)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphInputTest4()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);

            if (item1.IsGraphInput)
                throw new Exception();
            if (item2.IsGraphInput)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphInputTest5()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[1]);

            if (item1.IsGraphInput)
                throw new Exception();
            if (item2.IsGraphInput)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphInputTest6()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[1], item2.InputPlugs[1]);

            if (item1.IsGraphInput)
                throw new Exception();
            if (item2.IsGraphInput)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphInputTest7()
        {
            var item1 = new ProducerWorkflowItem("A");
            var item2 = new ConsumerWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[1]);

            if (item1.IsGraphInput == false)
                throw new Exception();
            if (item2.IsGraphInput)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphInputTest8()
        {
            var item1 = new ProducerWorkflowItem("A");
            var item2 = new ConsumerWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[1], item2.InputPlugs[1]);

            if (item1.IsGraphInput == false)
                throw new Exception();
            if (item2.IsGraphInput)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphOutputTest1()
        {
            var item1 = new WorkflowItem<object>();

            if (item1.IsGraphOutput)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphOutputTest2()
        {
            var item1 = new DummyWorkflowItem("A");

            if (item1.IsGraphOutput)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphOutputTest3()
        {
            var item1 = new ConsumerWorkflowItem("A");

            if (item1.IsGraphOutput)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphOutputTest4()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);

            if (item1.IsGraphOutput)
                throw new Exception();
            if (item2.IsGraphOutput)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphOutputTest5()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[1]);

            if (item1.IsGraphOutput)
                throw new Exception();
            if (item2.IsGraphOutput)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphOutputTest6()
        {
            var item1 = new DummyWorkflowItem("A");
            var item2 = new DummyWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[1], item2.InputPlugs[1]);

            if (item1.IsGraphOutput)
                throw new Exception();
            if (item2.IsGraphOutput)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphOutputTest7()
        {
            var item1 = new ProducerWorkflowItem("A");
            var item2 = new ConsumerWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[1]);

            if (item1.IsGraphOutput)
                throw new Exception();
            if (item2.IsGraphOutput == false)
                throw new Exception();
        }

        [TestMethod]
        public void IsGraphOutputTest8()
        {
            var item1 = new ProducerWorkflowItem("A");
            var item2 = new ConsumerWorkflowItem("B");

            ConnectionManager.Connect(item1.OutputPlugs[0], item2.InputPlugs[0]);
            ConnectionManager.Connect(item1.OutputPlugs[1], item2.InputPlugs[1]);

            if (item1.IsGraphOutput)
                throw new Exception();
            if (item2.IsGraphOutput == false)
                throw new Exception();
        }
    }
}
