﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Workflow.Core;

namespace UnitTests
{
    [TestClass]
    public class WorkflowCoreGraph
    {
        [TestMethod]
        public void AddGraphTest1()
        {
            var value1 = new ValueWorkflowItem(3.0);
            var value2 = new ValueWorkflowItem(5.0);

            var result = new AddWorkflowItem();

            ConnectionManager.Connect(value1.OutputPlugs[0], result.InputPlugs[0]);
            ConnectionManager.Connect(value2.OutputPlugs[0], result.InputPlugs[1]);

            if (Utility.IsEqual(result.OutputPlugs[0].Value, 8.0) == false)
                throw new Exception();
        }

        [TestMethod]
        public void AddGraphTest2()
        {
            var value1 = new ValueWorkflowItem(3.0);
            var value2 = new ValueWorkflowItem(5.0);

            var result = new AddWorkflowItem();

            ConnectionManager.Connect(value1.OutputPlugs[0], result.InputPlugs[0]);
            ConnectionManager.Connect(value2.OutputPlugs[0], result.InputPlugs[1]);

            if (Utility.IsEqual(result.OutputPlugs[0].Value, 8.0) == false)
                throw new Exception();

            value1.SetValue(9.0);

            if (Utility.IsEqual(result.OutputPlugs[0].Value, 14.0) == false)
                throw new Exception();
        }

        [TestMethod]
        public void SubGraphTest1()
        {
            var value1 = new ValueWorkflowItem(3.0);
            var value2 = new ValueWorkflowItem(5.0);

            var result = new SubWorkflowItem();

            ConnectionManager.Connect(value1.OutputPlugs[0], result.InputPlugs[0]);
            ConnectionManager.Connect(value2.OutputPlugs[0], result.InputPlugs[1]);

            if (Utility.IsEqual(result.OutputPlugs[0].Value, -2.0) == false)
                throw new Exception();
        }

        [TestMethod]
        public void SubGraphTest2()
        {
            var value1 = new ValueWorkflowItem(3.0);
            var value2 = new ValueWorkflowItem(5.0);

            var result = new AddWorkflowItem();

            ConnectionManager.Connect(value1.OutputPlugs[0], result.InputPlugs[0]);
            ConnectionManager.Connect(value2.OutputPlugs[0], result.InputPlugs[1]);

            if (Utility.IsEqual(result.OutputPlugs[0].Value, 8.0) == false)
                throw new Exception();

            value1.SetValue(9.0);

            if (Utility.IsEqual(result.OutputPlugs[0].Value, 14.0) == false)
                throw new Exception();
        }

        [TestMethod]
        public void MulGraphTest1()
        {
            var value1 = new ValueWorkflowItem(3.0);
            var value2 = new ValueWorkflowItem(5.0);

            var result = new MulWorkflowItem();

            ConnectionManager.Connect(value1.OutputPlugs[0], result.InputPlugs[0]);
            ConnectionManager.Connect(value2.OutputPlugs[0], result.InputPlugs[1]);

            if (Utility.IsEqual(result.OutputPlugs[0].Value, 15.0) == false)
                throw new Exception();
        }

        [TestMethod]
        public void MulGraphTest2()
        {
            var value1 = new ValueWorkflowItem(3.0);
            var value2 = new ValueWorkflowItem(5.0);

            var result = new MulWorkflowItem();

            ConnectionManager.Connect(value1.OutputPlugs[0], result.InputPlugs[0]);
            ConnectionManager.Connect(value2.OutputPlugs[0], result.InputPlugs[1]);

            if (Utility.IsEqual(result.OutputPlugs[0].Value, 15.0) == false)
                throw new Exception();

            value1.SetValue(9.0);

            if (Utility.IsEqual(result.OutputPlugs[0].Value, 45.0) == false)
                throw new Exception();
        }

        [TestMethod]
        public void AddMulGraphTest1()
        {
            var value1 = new ValueWorkflowItem(3.0);
            var value2 = new ValueWorkflowItem(5.0);

            var result = new AddMulWorkflowItem();

            ConnectionManager.Connect(value1.OutputPlugs[0], result.InputPlugs[0]);
            ConnectionManager.Connect(value2.OutputPlugs[0], result.InputPlugs[1]);

            if (Utility.IsEqual(result.OutputPlugs[0].Value, 8.0) == false)
                throw new Exception();
            if (Utility.IsEqual(result.OutputPlugs[1].Value, 15.0) == false)
                throw new Exception();
        }

        [TestMethod]
        public void AddMulGraphTest2()
        {
            var value1 = new ValueWorkflowItem(3.0);
            var value2 = new ValueWorkflowItem(5.0);

            var result = new AddMulWorkflowItem();

            ConnectionManager.Connect(value1.OutputPlugs[0], result.InputPlugs[0]);
            ConnectionManager.Connect(value2.OutputPlugs[0], result.InputPlugs[1]);

            if (Utility.IsEqual(result.OutputPlugs[0].Value, 8.0) == false)
                throw new Exception();
            if (Utility.IsEqual(result.OutputPlugs[1].Value, 15.0) == false)
                throw new Exception();

            value1.SetValue(9.0);

            if (Utility.IsEqual(result.OutputPlugs[0].Value, 14.0) == false)
                throw new Exception();
            if (Utility.IsEqual(result.OutputPlugs[1].Value, 45.0) == false)
                throw new Exception();
        }

        [TestMethod]
        public void AddMulThenSubGraphTest1()
        {
            var value1 = new ValueWorkflowItem(30.0);
            var value2 = new ValueWorkflowItem(50.0);
            var value3 = new ValueWorkflowItem(15.0);

            var addmul = new AddMulWorkflowItem();
            var sub1 = new SubWorkflowItem();
            var sub2 = new SubWorkflowItem();

            ConnectionManager.Connect(value1.OutputPlugs[0], addmul.InputPlugs[0]);
            ConnectionManager.Connect(value2.OutputPlugs[0], addmul.InputPlugs[1]);

            ConnectionManager.Connect(addmul.OutputPlugs[0], sub1.InputPlugs[0]);
            ConnectionManager.Connect(addmul.OutputPlugs[1], sub2.InputPlugs[0]);

            ConnectionManager.Connect(value3.OutputPlugs[0], sub1.InputPlugs[1]);
            ConnectionManager.Connect(value3.OutputPlugs[0], sub2.InputPlugs[1]);

            if (Utility.IsEqual(addmul.OutputPlugs[0].Value, 80.0) == false)
                throw new Exception();
            if (Utility.IsEqual(addmul.OutputPlugs[1].Value, 1500.0) == false)
                throw new Exception();

            if (Utility.IsEqual(sub1.OutputPlugs[0].Value, 65.0) == false)
                throw new Exception();
            if (Utility.IsEqual(sub2.OutputPlugs[0].Value, 1485.0) == false)
                throw new Exception();
        }

        [TestMethod]
        public void AddMulThenSubGraphTest2()
        {
            var value1 = new ValueWorkflowItem(30.0);
            var value2 = new ValueWorkflowItem(50.0);
            var value3 = new ValueWorkflowItem(15.0);

            var addmul = new AddMulWorkflowItem();
            var sub1 = new SubWorkflowItem();
            var sub2 = new SubWorkflowItem();

            ConnectionManager.Connect(value1.OutputPlugs[0], addmul.InputPlugs[0]);
            ConnectionManager.Connect(value2.OutputPlugs[0], addmul.InputPlugs[1]);

            ConnectionManager.Connect(addmul.OutputPlugs[0], sub1.InputPlugs[0]);
            ConnectionManager.Connect(addmul.OutputPlugs[1], sub2.InputPlugs[0]);

            ConnectionManager.Connect(value3.OutputPlugs[0], sub1.InputPlugs[1]);
            ConnectionManager.Connect(value3.OutputPlugs[0], sub2.InputPlugs[1]);

            if (Utility.IsEqual(addmul.OutputPlugs[0].Value, 80.0) == false)
                throw new Exception();
            if (Utility.IsEqual(addmul.OutputPlugs[1].Value, 1500.0) == false)
                throw new Exception();

            if (Utility.IsEqual(sub1.OutputPlugs[0].Value, 65.0) == false)
                throw new Exception();
            if (Utility.IsEqual(sub2.OutputPlugs[0].Value, 1485.0) == false)
                throw new Exception();

            value3.SetValue(40.0);

            if (Utility.IsEqual(addmul.OutputPlugs[0].Value, 80.0) == false)
                throw new Exception();
            if (Utility.IsEqual(addmul.OutputPlugs[1].Value, 1500.0) == false)
                throw new Exception();

            if (Utility.IsEqual(sub1.OutputPlugs[0].Value, 40.0) == false)
                throw new Exception();
            if (Utility.IsEqual(sub2.OutputPlugs[0].Value, 1460.0) == false)
                throw new Exception();
        }

        [TestMethod]
        public void AddMulThenSubGraphTest3()
        {
            var value1 = new ValueWorkflowItem(30.0);
            var value2 = new ValueWorkflowItem(50.0);
            var value3 = new ValueWorkflowItem(15.0);

            var addmul = new AddMulWorkflowItem();
            var sub1 = new SubWorkflowItem();
            var sub2 = new SubWorkflowItem();

            ConnectionManager.Connect(value1.OutputPlugs[0], addmul.InputPlugs[0]);
            ConnectionManager.Connect(value2.OutputPlugs[0], addmul.InputPlugs[1]);

            ConnectionManager.Connect(addmul.OutputPlugs[0], sub1.InputPlugs[0]);
            ConnectionManager.Connect(addmul.OutputPlugs[1], sub2.InputPlugs[0]);

            ConnectionManager.Connect(value3.OutputPlugs[0], sub1.InputPlugs[1]);
            ConnectionManager.Connect(value3.OutputPlugs[0], sub2.InputPlugs[1]);

            if (Utility.IsEqual(addmul.OutputPlugs[0].Value, 80.0) == false)
                throw new Exception();
            if (Utility.IsEqual(addmul.OutputPlugs[1].Value, 1500.0) == false)
                throw new Exception();

            if (Utility.IsEqual(sub1.OutputPlugs[0].Value, 65.0) == false)
                throw new Exception();
            if (Utility.IsEqual(sub2.OutputPlugs[0].Value, 1485.0) == false)
                throw new Exception();

            value3.SetValue(40.0);

            if (Utility.IsEqual(addmul.OutputPlugs[0].Value, 80.0) == false)
                throw new Exception();
            if (Utility.IsEqual(addmul.OutputPlugs[1].Value, 1500.0) == false)
                throw new Exception();

            if (Utility.IsEqual(sub1.OutputPlugs[0].Value, 40.0) == false)
                throw new Exception();
            if (Utility.IsEqual(sub2.OutputPlugs[0].Value, 1460.0) == false)
                throw new Exception();

            value2.SetValue(2.0);

            if (Utility.IsEqual(addmul.OutputPlugs[0].Value, 32.0) == false)
                throw new Exception();
            if (Utility.IsEqual(addmul.OutputPlugs[1].Value, 60.0) == false)
                throw new Exception();

            if (Utility.IsEqual(sub1.OutputPlugs[0].Value, -8.0) == false)
                throw new Exception();
            if (Utility.IsEqual(sub2.OutputPlugs[0].Value, 20.0) == false)
                throw new Exception();
        }
    }
}
