﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;

namespace ShaderTyping
{
    /// <summary>
    /// Abstract definition of a shader langage type.
    /// </summary>
    public abstract class ShaderTypeDefinition : IEquatable<ShaderTypeDefinition>
    {
        public abstract bool IsVoid { get; }

        public override bool Equals(object obj)
        {
            if (obj is ShaderTypeDefinition)
                return Equals((ShaderTypeDefinition)obj);

            return false;
        }

        public abstract bool Equals(ShaderTypeDefinition other);
        public abstract override int GetHashCode();

        public static bool operator ==(ShaderTypeDefinition t1, ShaderTypeDefinition t2)
        {
            if ((object)t1 == null)
                return (object)t2 == null;

            return t1.Equals(t2);
        }

        public static bool operator !=(ShaderTypeDefinition t1, ShaderTypeDefinition t2)
        {
            return !(t1 == t2);
        }
    }
}
