﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using ShaderGenerator.GLSL;

namespace ShaderGeneratorTests
{
    [TestClass]
    public class VariableGeneratorTests
    {
        [TestMethod]
        public void GenerateNewAreUnique()
        {
            var generator = new VariableGenerator();
            var intType = new EffectDefinitions.ShaderTypeDefinition("int");
            var variables = new List<Variable>();

            for (int i = 0; i < 1000; ++i)
            {
                variables.Add(generator.GenerateNew("foo", "bar", intType));
            }

            foreach (var variable in variables)
                if (variable.Type != intType)
                {
                    throw new Exception("Type differs");
                }

            var uniqueNames = variables.Select(x => x.Name).Distinct();
            var numberOfNames = uniqueNames.Count();
            var expectedNumberOfNames = variables.Count();
            if (numberOfNames != expectedNumberOfNames)
            {
                throw new Exception(string.Format("GenerateNew generated {0} distinct names instead of {1}", numberOfNames, expectedNumberOfNames));
            }
        }
    }
}
