﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.IO;

using ShaderTyping;

namespace ShaderGenerator.GLSL
{
    public static class Extensions
    {
        public static string GetPrototype(this FunctionDefinition function)
        {
            var parameters = string.Join(", ", function.Parameters.Select(a => a.GetPrototype()));
            return string.Format("{0} {1}({2});", function.ReturnType, function.Name, parameters);
        }

        public static string GetPrototype(this ParameterDefinition parameter)
        {
            string direction = string.Empty;
            switch (parameter.Direction)
            {
                case ParameterDirection.Input: direction = "in"; break;
                case ParameterDirection.Output: direction = "out"; break;
                case ParameterDirection.Reference: direction = "inout"; break;
            }
            return string.Format("{0} {1} {2}", direction, parameter.Type.ToString(), parameter.Name);
        }
    }
}
