﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ShaderTyping;

namespace ShaderGenerator.Core
{
    /// <summary>
    /// Represent a local state of shader code generation.
    /// </summary>
    /// <typeparam name="TContext">Type of the GenerationContext it belongs to.</typeparam>
    /// <typeparam name="TFunc">Type of the FunctionDefinition it operates over.</typeparam>
    /// <typeparam name="TPlugValue">Type of the value passed from state to state.</typeparam>
    public abstract class Generator<TContext, TFunc, TPlugValue>
        where TContext : GenerationContext<TFunc, TPlugValue>
        where TFunc : FunctionDefinition
    {
        /// <summary>
        /// Gets the GenerationContext the current Generator belongs to.
        /// </summary>
        public TContext Context { get; private set; }

        protected Generator(TContext context)
        {
            if (context == null)
                throw new ArgumentNullException("context");

            Context = context;
        }

        public abstract TPlugValue[] ProduceOutputs(TFunc function, TPlugValue[] inputs);
    }
}
