﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ShaderTyping;

namespace ShaderGenerator.Core
{
    /// <summary>
    /// Global context for a shader code generation process.
    /// </summary>
    /// <typeparam name="TFunc">Type of the FunctionDefinition it operates over.</typeparam>
    /// <typeparam name="TPlugValue">Type of the value passed from state to state.</typeparam>
    public abstract class GenerationContext<TFunc, TPlugValue>
        where TFunc : FunctionDefinition
    {
        private static readonly string BeginEndErrorMessage = string.Format(
            Messages.EXCEPTION_CODE_GENERATION_INVALID_OPERATION,
            "BeginGeneration", "EndGeneration");

        public Type FunctionType { get { return typeof(TFunc); } }
        public Type PlugValueType { get { return typeof(TPlugValue); } }

        public bool IsGenerating { get; private set; }

        public virtual void BeginGeneration()
        {
            if (IsGenerating)
                throw new InvalidOperationException(BeginEndErrorMessage);

            IsGenerating = true;
        }

        public virtual void EndGeneration()
        {
            if (IsGenerating == false)
                throw new InvalidOperationException(BeginEndErrorMessage);

            IsGenerating = false;
        }
    }
}
