﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Renderer2D.Core;
using Renderer2D.Core.WinForms;

namespace WinFormsTestApp
{
    public partial class RendererDisplayControl : UserControl
    {
        // for Design time only
        public RendererDisplayControl()
        {
            InitializeComponent();
        }

        public RenderSurface RenderSurface { get; private set; }

        public void SetRenderer(Renderer renderer)
        {
            if (renderer == null)
                throw new ArgumentNullException("renderer");

            lblRendererType.Text = renderer.GetType().FullName;
            ttpRendererName.SetToolTip(lblRendererType, renderer.GetType().FullName);

            try
            {
                RenderSurface = new RenderSurface(this)
                {
                    Top = lblRendererType.Bottom + 3,
                    Left = 3,
                    Width = this.Width - 6,
                    Height = this.Height - lblRendererType.Bottom - 6,
                    BorderStyle = BorderStyle.FixedSingle,
                    BackColor = System.Drawing.Color.White,
                    Anchor = AnchorStyles.Top | AnchorStyles.Bottom | AnchorStyles.Left | AnchorStyles.Right,
                };
            }
            catch (Exception ex)
            {
                AddError(ex);
            }

            if (RenderSurface != null)
            {
                SuspendLayout();
                Controls.Add(RenderSurface);

                renderer.Initialize();
                RenderSurface.SetRenderer(renderer);
                RenderSurface.InitializeResources();

                ResumeLayout();
            }
        }

        public void AddError(Exception ex)
        {
            if (ex == null)
                throw new ArgumentNullException("ex");

            if (RenderSurface != null)
                RenderSurface.Visible = false;

            txtErrorLog.Text += ex.Dump();
            txtErrorLog.Text += Environment.NewLine;
            txtErrorLog.Visible = true;
        }

        protected override void OnParentChanged(EventArgs e)
        {
            base.OnParentChanged(e);

            if (Parent == null) // detached
                RenderSurface.Terminate();
        }
    }
}
