﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

namespace WinFormsTestApp
{
    public static class Extensions
    {
        public static void Send(this SynchronizationContext context, Action action)
        {
            if (context == null)
                throw new ArgumentNullException("context");
            if (action == null)
                throw new ArgumentNullException("action");

            context.Send(_ => action(), null);
        }

        public static void Post(this SynchronizationContext context, Action action)
        {
            if (context == null)
                throw new ArgumentNullException("context");
            if (action == null)
                throw new ArgumentNullException("action");

            context.Post(_ => action(), null);
        }

        public static string Dump(this Exception ex)
        {
            if (ex == null)
                throw new ArgumentNullException("ex");

            return DumpRecursive(ex, 0);
        }

        private static string DumpRecursive(Exception ex, int level)
        {

            var sb = new StringBuilder();

            sb.AppendLine(string.Format("Type: {0}", ex.GetType().FullName));
            sb.AppendLine(string.Format("Message: {0}", ex.Message));

            DumpStackTrace(level, ex.StackTrace, sb);

            if (ex.InnerException != null)
            {
                sb.AppendLine();
                DumpRecursive(ex.InnerException, level + 1);
            }

            return sb.ToString();
        }

        private static void DumpStackTrace(int level, string stackTrace, StringBuilder sb)
        {
            var indent = new string(' ', 2 + level * 4);

            foreach (var line in stackTrace.Split('\n').Select(l => l.Trim()))
                sb.AppendLine(string.Format("{0}{1}", indent, line));
        }
    }
}
