﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace Renderer2D.Core
{
    public interface IColor
    {
        byte R { get; set; }
        byte G { get; set; }
        byte B { get; set; }
        byte A { get; set; }
    }

    public class Color : IColor
    {
        public Color()
        {
        }

        public Color(byte r, byte g, byte b)
            : this(r, g, b, 255)
        {
        }

        public Color(IColor rgb, byte a)
            : this(rgb.R, rgb.G, rgb.B, a)
        {
        }

        public Color(byte r, byte g, byte b, byte a)
        {
            R = r;
            G = g;
            B = b;
            A = a;
        }

        public Color(double sr, double sg, double sb, double sa)
        {
            R = (byte)(Math.Max(0.0, Math.Min(sr, 1.0)) * 255.0);
            G = (byte)(Math.Max(0.0, Math.Min(sg, 1.0)) * 255.0);
            B = (byte)(Math.Max(0.0, Math.Min(sb, 1.0)) * 255.0);
            A = (byte)(Math.Max(0.0, Math.Min(sa, 1.0)) * 255.0);
        }

        public byte R { get; set; }
        public byte G { get; set; }
        public byte B { get; set; }
        public byte A { get; set; }

        public override string ToString()
        {
            return string.Format("R = {0}, G = {1}, B = {2}, A = {3}", R, G, B, A);
        }
    }
}
