﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Drawing.Imaging;
using System.Text;
using System.Runtime.InteropServices;

namespace Renderer2D.Core.WinForms
{
    public static class Extensions
    {
        public static IPoint ToRendererPoint(this System.Drawing.PointF point)
        {
            return new Point(point.X, point.Y);
        }

        public static ISize ToRendererSize(this System.Drawing.SizeF size)
        {
            return new Size(size.Width, size.Height);
        }

        public static IColor ToRendererColor(this System.Drawing.Color color)
        {
            return new Color(color.R, color.G, color.B, color.A);
        }

        public static IBitmapDefinition ToRendererBitmapDefinition(this System.Drawing.Bitmap bitmap)
        {
            if (bitmap == null)
                throw new ArgumentNullException("bitmap");

            var rect = new System.Drawing.Rectangle(0, 0, bitmap.Width, bitmap.Height);
            var bitmapData = bitmap.LockBits(rect, ImageLockMode.ReadOnly, PixelFormat.Format32bppPArgb);
            try
            {
                var buffer = new byte[bitmap.Width * bitmap.Height * 4];
                Marshal.Copy(bitmapData.Scan0, buffer, 0, buffer.Length);
                return new BitmapDefinition(buffer, bitmap.Width, bitmap.Height);
            }
            finally
            {
                bitmap.UnlockBits(bitmapData);
            }
        }
    }
}
