﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace EnvironmentReporting
{
    public class ContextInformationContainer : ContextInformation, IDictionary<string, ContextInformation>
    {
        private Dictionary<string, ContextInformation> dictionary = new Dictionary<string, ContextInformation>();

        public ContextInformationContainer()
        {
        }

        public void Add(string key, ContextInformation value)
        {
            dictionary.Add(key, value);
        }

        public bool ContainsKey(string key)
        {
            return dictionary.ContainsKey(key);
        }

        public ICollection<string> Keys
        {
            get { return dictionary.Keys; }
        }

        public bool Remove(string key)
        {
            return dictionary.Remove(key);
        }

        public bool TryGetValue(string key, out ContextInformation value)
        {
            return dictionary.TryGetValue(key, out value);
        }

        public ICollection<ContextInformation> Values
        {
            get { return dictionary.Values; }
        }

        public ContextInformation this[string key]
        {
            get
            {
                return dictionary[key];
            }
            set
            {
                dictionary[key] = value;
            }
        }

        public void Add(KeyValuePair<string, ContextInformation> item)
        {
            dictionary.Add(item.Key, item.Value);
        }

        public void Clear()
        {
            dictionary.Clear();
        }

        public bool Contains(KeyValuePair<string, ContextInformation> item)
        {
            return dictionary.Contains(item);
        }

        public void CopyTo(KeyValuePair<string, ContextInformation>[] array, int arrayIndex)
        {
            throw new NotImplementedException();
        }

        public int Count
        {
            get { return dictionary.Count; }
        }

        public bool IsReadOnly
        {
            get { return false; }
        }

        public bool Remove(KeyValuePair<string, ContextInformation> item)
        {
            throw new NotImplementedException();
        }

        public IEnumerator<KeyValuePair<string, ContextInformation>> GetEnumerator()
        {
            return dictionary.GetEnumerator();
        }

        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            throw new NotImplementedException();
        }

        public override string ToString()
        {
            return string.Format("ContextInformationContainer[{0}]", dictionary.Count());
        }
    }
}
