﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net.NetworkInformation;

using EnvironmentReporting;

namespace EnvironmentInformationProvider
{
    public class NetworkInformationProvider : IInformationProvider
    {
        public string InformationDescription { get { return "Network"; } }

        public ContextInformation GetInformation()
        {
            var networkInfo = new ContextInformationContainer();

            networkInfo.Add("Network connection present (broken)", new DecimalContextInformation(SystemInformation.Network ? 1 : 0));
            networkInfo.Add("Network available", new DecimalContextInformation(System.Net.NetworkInformation.NetworkInterface.GetIsNetworkAvailable() ? 1 : 0));

            var networkInterfacesInfo = new ContextInformationContainer();
            var networkInterfaces = NetworkInterface.GetAllNetworkInterfaces();
            var screensInfo = new ContextInformationContainer();
            int i = 0;
            foreach (var networkInterface in networkInterfaces)
            {
                var networkInterfaceInfo = new ContextInformationContainer();

                networkInterfaceInfo.Add("Id", new StringContextInformation(networkInterface.Id));
                networkInterfaceInfo.Add("Name", new StringContextInformation(networkInterface.Name));
                networkInterfaceInfo.Add("Type", new StringContextInformation(networkInterface.NetworkInterfaceType.ToString()));
                networkInterfaceInfo.Add("Description", new StringContextInformation(networkInterface.Description));
                networkInterfaceInfo.Add("Speed (bps)", new DecimalContextInformation(networkInterface.Speed));
                networkInterfaceInfo.Add("Operational status", new StringContextInformation(networkInterface.OperationalStatus.ToString()));

                try { networkInterfaceInfo.Add("Multicast support", new DecimalContextInformation(networkInterface.SupportsMulticast ? 1 : 0)); }
                catch (PlatformNotSupportedException) { networkInterfaceInfo.Add("Multicast support", new StringContextInformation("Not supported")); }
                try { networkInterfaceInfo.Add("Receive only", new DecimalContextInformation(networkInterface.IsReceiveOnly ? 1 : 0)); }
                catch (PlatformNotSupportedException) { networkInterfaceInfo.Add("Receive only", new StringContextInformation("Not supported")); }

                networkInterfacesInfo.Add(i.ToString(), networkInterfaceInfo);
                ++i;
            }
            networkInfo.Add("Network interfaces", networkInterfacesInfo);

            return networkInfo;
        }
    }
}
